/*
 * Author : Reimer A. Mellin
 * Date : 4.12.1991
 * no copyrights
 *
 *
 * ulaw: based on recordchaintest.c
 * it writes a endless stream of Sound to stdout until terminated or
 * interrupted.
 * sndrecord can't be used, since it can not write to stdout :-(
 */ 

#import	<stdio.h>
#import <signal.h>
#import	<sound/sound.h>

#define	NUM_BUFFERS	5
#define	BUF_SIZE	8000

static SNDSoundStruct *buffers[NUM_BUFFERS];
static FILE *sfp;

static void record(int tag);

static int recordDone(SNDSoundStruct *s, int tag, int err)
/*
 * Called when a buffer has been recorded.
 * Appends the buffer to the soundfile.
 */
{
    if (err)
        fprintf(stderr, "recordDone: %s\n", SNDSoundError(err));
    if (fwrite((void *)((char *)s + s->dataLocation), 1, s->dataSize, sfp) !=
	s->dataSize)
	fprintf(stderr, "recordDone: could not write data to soundfile\n");
    return 0;
}

static void record(int bufNum)
/*
 * Initiates recording into a buffers[bufNum].
 */
{
    int err;
    

    if (err = SNDStartRecording(buffers[bufNum], bufNum+1, 0, 0, SND_NULL_FUN,
				recordDone))
        fprintf(stderr, "record: %s\n", SNDSoundError(err));
}

static void init(int n, int size)
/*
 * Allocate n sound buffers.
 * Creates the soundfile.
 */
{
    int i, err;
    SNDSoundStruct s;

    for (i = 0; i < n; i++)
        if (err = SNDAlloc(&buffers[i], size, SND_FORMAT_MULAW_8,
			   SND_RATE_CODEC, 1, 4))
	    fprintf(stderr, "init: %s\n", SNDSoundError(err));

    s.magic = SND_MAGIC;
    s.dataLocation = sizeof(SNDSoundStruct);
    s.dataSize = 0;
    s.dataFormat = SND_FORMAT_MULAW_8;
    s.samplingRate = SND_RATE_CODEC;
    s.channelCount = 1;
    (void)strcpy( s.info, "ram");
    if (fwrite((void *)&s, sizeof(SNDSoundStruct), 1, sfp) != 1)
	fprintf(stderr, "init: could not write dummy header to soundfile\n");
}

static void cleanup(void)
/*
 * Write the soundfile header.
 */
{
    SNDSoundStruct s;

    s.magic = SND_MAGIC;
    s.dataLocation = sizeof(SNDSoundStruct);
    s.dataSize = 0;
    s.dataFormat = SND_FORMAT_MULAW_8;
    s.samplingRate = SND_RATE_CODEC;
    s.channelCount = 1;
    (void)strcpy( s.info, "ram");

    if(!isatty(fileno(sfp))) {
      rewind(sfp);
      if (fwrite((void *)&s, sizeof(SNDSoundStruct), 1, sfp) != 1)
	fprintf(stderr, "cleanup: could not write header to soundfile\n");
    }
    fflush(sfp);
    exit(0);
}

main(int argc, char *argv[])
{
    int i;

    if( argc > 1 ) {
      fprintf(stderr, "%s: Records sound from CODEC and writes it to stdout\n",
	      argv[0]);
      exit(1);
    }
    sfp = stdout;
    (void)signal( SIGTERM, (void *)cleanup);
    (void)signal( SIGINT, (void *)cleanup);

    /* prepare sound and start the first 5 recordings */
    init(NUM_BUFFERS, BUF_SIZE);
    for (i = 0; i < NUM_BUFFERS; i++) {
      record(i);
    }
    for(;;){
      /* As soon as the first is finished, restart it */
      for (i = 0; i < NUM_BUFFERS; i++) {
	SNDWait(i+1);
	record(i);
      }
    }
    cleanup();
}
