/***********************************************************
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Record SGI audio data and output it as 8 kHz signed 16-bits samples,
   converting the sampling rate and encoding on the fly.
   This writes to stdout.
   
   Caveats:
   - since it uses an audio port, of which there can only be 4 open
     at a time, running several copies is not a good idea;
     see broadcast.c and radio.c for a distribution mechanism.

  To do:
  - support the other three sampling rates
*/

#include <stdio.h>
#include <audio.h>

int inrate;

#define OUTRATE	8000
#define INBUFSIZE 48000

main(argc, argv)
	int argc;
	char **argv;
{
	short inbuf[INBUFSIZE];
	short outbuf[8000];
	ALconfig c;
	ALport p;
	int n;
	int insamps;
	int sts = 0;
	
	checkinrate();
	insamps = calcinsamps();
	
	c = ALnewconfig();
	if (c == NULL) {
		perror("ALnewconfig");
		exit(1);
	}
	ALsetwidth(c, AL_SAMPLE_16);
	ALsetchannels(c, AL_MONO);
	
	p = ALopenport(argv[0], "r", c);
	if (p == NULL) {
		perror("ALopenport");
		exit(1);
	}

	for (;;) {
		checkinrate();
		insamps = calcinsamps();
		ALreadsamps(p, (void *)inbuf, insamps);
		n = convert(inbuf, insamps, outbuf);
		n = n * sizeof(short);
		if (write(1, (char *)outbuf, n) != n) {
			perror("write error");
			sts = 1;
			break;
		}
	}

	exit(sts);
}

int calcinsamps()
{
	int insamps = inrate/2;
	if (insamps > INBUFSIZE)
		insamps = INBUFSIZE;
	return insamps;
}

checkinrate()
{
	inrate = getinrate();
	if ((inrate/OUTRATE)*OUTRATE != inrate) {
		fprintf(stderr,
			"current sampling rate (%d) is not a multiple of %d\n",
			inrate, OUTRATE);
		exit(1);
	}
}

int getinrate()
{
	long PVbuffer[2];
	
	PVbuffer[0] = AL_INPUT_RATE;
	ALgetparams(AL_DEFAULT_DEVICE, PVbuffer, 2);
	return PVbuffer[1];
}

int convert(inbuf, n, outbuf)
	short *inbuf;
	int n;
	short *outbuf;
{
	register short *inp = inbuf;
	register short *inend = inbuf + n;
	register int di = inrate/OUTRATE;
	register int x;
	register short *outp = outbuf;

	while (inp < inend) {
		switch (di) {
		case 1:
			*outp++ = *inp++;
			break;
		case 2:
			x = *inp++;
			x += *inp++;
			*outp++ = x >> 1;
			break;
		case 4:
			x = *inp++;
			x += *inp++;
			x += *inp++;
			x += *inp++;
			*outp++ = x >> 2;
			break;
		case 6:
			x = *inp++;
			x += *inp++;
			x += *inp++;
			x += *inp++;
			x += *inp++;
			x += *inp++;
			*outp++ = x / 24;
			break;
		}
	}

	return outp - outbuf;
}
