/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* svga display class interface definitions                               */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: svga_display.h,v 0.1 1995/04/15 18:37:00 drewvel Exp $

/*******************************************************************/
#ifndef __SVGA_DISPLAYH_INC
#define __SVGA_DISPLAYH_INC

#include "display.h"
#include "colors.h"

/*******************************************************************/
void doBox(int x1, int y1, int x2, int y2, int col);
void FadeBox(int x1, int y1, int x2, int y2,
	     Color& from_col, Color& to_col, 
	     int width, boolean fill=false, int bgcol=0);
void ShowColorsV(unsigned char *cols, int num, 
		 int x, int y, 
		 int w, int h,
		 boolean reverse);


/*******************************************************************/
class SVGA_Display:public Display {
private:
  void *fp;

protected:
  boolean display_on;
  boolean clipping_enabled;

  void FontColor(int color);  
  void InitScreen();
  void SetupScreen();
  void WriteStr(int x, int y, int color, char *str);

  void DrawYAxis();
  void DrawXAxis();

  void EnableClipping();
  void DisableClipping();

public:

  SVGA_Display(int n, Signal& S, 
	      aScreen &screen, int t=1,
	      boolean st=DEFLOGSCALE);
  ~SVGA_Display();

  void Reset();

  void GetScrConfig(globalConfig& config);
  void SetScrConfig(globalConfig& config);
  void ChangeScreen(int num);
  void ClearGraph();
  void WriteInfo();

  void ProcessControl(char control);

  void Show();
  void UnShow();
  
};

#endif __SVGA_DISPLAYH_INC
