/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* svga line display class implementation                                 */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: s_line_display.cc,v 0.2 1995/05/01 22:04:53 drewvel Exp $             

/*******************************************************************/
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <vga.h>
#include <vgagl.h>
#include "s_line_display.h"
#include "analyzer.h"
#include "gconfig.h"
#include "signal.h"
#include "barconfig.h"
#include "colors.h"
#include "keymap.h"


/*******************************************************************/
SVGA_Line_Display::SVGA_Line_Display(int n, Signal& S, 
				     aScreen &screen, int t,
				     boolean st)
:SVGA_Display(n, S, screen, t, st)
{
  granularity=true;

  savedata=new int[num+1];
  
  DOUT("SVGA_Line_Display: allocated savedata array: " << num);

  for (int i=0; i<num+1; i++) 
    savedata[i]=theScreen.y2;
  
  intv=(float) Width()/(float) num;
}


/*******************************************************************/
SVGA_Line_Display::~SVGA_Line_Display(int n, Signal& S, 
				      aScreen &screen, int t=1,
				      boolean st=DEFLOGSCALE)
{
  delete [] savedata;
}


/*******************************************************************/
void SVGA_Line_Display::ChangeScreen(int number)
{
  DOUT("SVGA_Line_Display: ChangeScreen(" << number << ")");
  SVGA_Display::ChangeScreen(number);

  UpdateFreqIndex();
  for (int i=0; i<num+1; i++) 
    savedata[i]=theScreen.y2;
  intv=(float) Width()/(float) num;
}


/*******************************************************************/
void SVGA_Line_Display::DrawInit()
{
  DOUT("SVGA_Line_Display: DrawInit()");
  UpdateFreqIndex();
  DisableClipping();  
  DrawXAxis();
  DrawYAxis(); 
  ClearGraph();
  EnableClipping();
  DOUT("SVGA_Line_Display: DrawInit() -- out");
}


/*******************************************************************/
void SVGA_Line_Display::Reset()
{
  DOUT("SVGA_Line_Display: Reset() -- in");
  SVGA_Display::Reset();
  DrawInit();
  DOUT("SVGA_Line_Display: Reset() -- out");
}


/*******************************************************************/
void SVGA_Line_Display::Show()
{
  SVGA_Display::Show();
  DrawInit();
}


/*******************************************************************/
void SVGA_Line_Display::RefreshFreqs()
{
  SVGA_Display::RefreshFreqs();
  DisableClipping();
  DrawXAxis();
  DrawYAxis();
  EnableClipping();
}


/*******************************************************************/
void SVGA_Line_Display::ProcessControl(char control)
{
  SVGA_Display::ProcessControl(control);

  switch (control) {
  }
}
  

/*******************************************************************/
void SVGA_Line_Display::UpdateCoefficients()
{
  int oy=theScreen.y2, ny, ox, nx;

  ox=theScreen.x1;

  register int i;
  for (i=0; i<num; i++) {
    if (controls.LogYScale.isOn) 
      irms_val=(int) (logatten*
		      log10(rrms(&coefficients[index[i]], i_length[i])+1)
		      /controls.Attenuation.val+controls.VPosition.val);
    else
      irms_val=irms(&coefficients[index[i]], i_length[i])
	/controls.Attenuation.val+controls.VPosition.val;    
    
    ny=theScreen.y2-irms_val;

    ox=theScreen.x1+(int) ((float) i*intv);
    nx=theScreen.x1+(int) ((float) (i+1)*intv);

    gl_line(ox, savedata[i], nx, savedata[i+1], gConfig.GraphBG.val);
    gl_line(ox, oy, nx, ny, gConfig.LineColor.val);
    
    savedata[i]=oy;

    oy=ny;
  }
  savedata[num]=oy;
}

/*******************************************************************/
