/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* parameter class interface & definition                                 */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: parameters.h,v 0.2 1994/12/26 00:51:58 root Exp $             

#ifndef _PARAMETERCLASS
#define _PARAMETERCLASS
/* Parameter Class to handle parameter changing */
struct Parms {
  int Sample_Rate, Bit_Resolution;
  int sampbufsize;
  
  Parms(int bs=8000, int SRate=8000, int BRes=16) 
    { sampbufsize=bs; Sample_Rate=SRate; Bit_Resolution=BRes; }

  Parms& operator=(Parms& o) 
    { sampbufsize=o.sampbufsize;
      Sample_Rate=o.Sample_Rate; 
      Bit_Resolution=o.Bit_Resolution;
      return *this; }
};
#endif _PARAMETERCLASS

