/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* keyboard control map                                                   */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: keymap.h,v 0.5 1995/04/15 05:47:10 drewvel Exp $             

#ifndef __KEYMAP_H
#define __KEYMAP_H

// keys for main spectrum analzyer
#define K_SAMPLERATE_INC '}'
#define K_SAMPLERATE_DEC '{'
#define K_LOWFREQ_INC 'k'
#define K_LOWFREQ_DEC 'j'
#define K_HIGHFREQ_INC 'K'
#define K_HIGHFREQ_DEC 'J'
#define K_ATTEN_INC '+'
#define K_ATTEN_DEC '-'
#define K_VPOS_INC ']'
#define K_VPOS_DEC '['
#define K_MORELABELS '.'
#define K_LESSLABELS ','
#define K_FREQOFS_INC 'I' 
#define K_FREQOFS_DEC 'U'
#define K_CLEARGRAPH ' '
#define K_RESET 'r'
#define K_HELP '?'
#define K_HANNINGWINDOWTOGGLE 'w'
#define K_CALIBRATE 'c'
#define K_PAUSE 'p'
#define K_SAVEOPTIONS 's'
#define K_SIGFLUSH 'f'
#define K_REVERTDEFAULTS 'd'
#define K_TOGGLEBITRES 'b'
#define K_ATTENVPOSZERO 'z'
#define K_EXIT 'x'
#define K_LOGXSCALE_TOGGLE ';'
#define K_LOGYSCALE_TOGGLE 'l'
#define K_GO_SVGA_LINE_DISPLAY 'y'
#define K_GO_SVGA_BAR_DISPLAY 'u'
#define K_GO_SVGA_WAVEFORM_DISPLAY_3D 'i'
#define K_GO_SVGA_CONTINUOUS_WAVEFORM_DISPLAY_3D 'o'


// keymaps specifit to certain displays

// base keys for SVGA_Display
#define K_SD_SCREEN0 '~'
#define K_SD_SCREEN1 '!'
#define K_SD_SCREEN2 '@'
#define K_SD_SCREEN3 '#'


// keys active under SVGA_Bar_Display 
// inherits keys from SVGA_Display
#define K_SBD_BARTYPE1 '1'
#define K_SBD_BARTYPE2 '2'
#define K_SBD_BARTYPE3 '3'
#define K_SBD_BARTYPE4 '4'
#define K_SBD_BARTYPE5 '5'
#define K_SBD_BARTYPE6 '6'



// keys for SVGA_Display_3D base
// inherits keys from SVGA_Display
#define K_SD3D_ROTX_DEC '1'
#define K_SD3D_ROTX_INC '2'
#define K_SD3D_ROTX_RESET '3'
#define K_SD3D_ROTY_DEC '4'
#define K_SD3D_ROTY_INC '5'
#define K_SD3D_ROTY_RESET '6'
#define K_SD3D_ROTZ_DEC '7'
#define K_SD3D_ROTZ_INC '8'
#define K_SD3D_ROTZ_RESET '9'
#define K_SD3D_TOGGLEPERSPECTIVE 'P'

// keys for SVGA_Waveform_Display_3D class 
// inherits keys from SVGA_Display_3D
#define K_SWD3D_XINT_INC '*'
#define K_SWD3D_XINT_DEC '&'
#define K_SWD3D_YINT_INC ')'
#define K_SWD3D_YINT_DEC '('

#endif __KEYMAP
