/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* control classes                                                        */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: controls.h,v 0.2 1995/04/15 05:43:58 drewvel Exp $


/*******************************************************************/
#include <iostream.h>
#include "bools.h"
#include "gconfig.h"


/*******************************************************************/
struct AControl {
  char name[24];
  
  AControl() { strcpy(name, "<undefined control>"); }

  char *Name(char *Name) { strcpy(name, Name); return name; }
  char *Name() { return name; }
  operator char *() { return name; }
};


/*******************************************************************/
struct Stepper {
  int min;
  int max;
  int step;
  
  Stepper() { min=max=-1; step=1; }

  int StepValue(int v) 
    {
      int retval;
      retval=v+v%step;
      if (min!=max) {
	if (retval>max) return max;
	if (retval<min) return min;
      } else if (min!=-1) 
	if (retval<=min) return min;

      return retval;
    }
  
  int StepUp(int v) { return StepValue(v+step); }
  int StepDown(int v) { return StepValue(v-step); }
};


/*******************************************************************/
struct IntControl:AControl, Stepper {
  int val;

  IntControl() { val=step; }
  
  IntControl& operator = (const int o) { val=StepValue(o); return *this; }
  IntControl& operator ++ () { val=StepUp(val); return *this; }
  IntControl& operator -- () { val=StepDown(val); return *this; }
};


/*******************************************************************/
struct RangeControl:AControl, Stepper {
  int low;
  int high;
  
  int Diff() { return high-low; }
  void SetLow(int val) { low=StepValue(val); Normalize(); }
  void SetHigh(int val) { high=StepValue(val); Normalize(); }

  void Normalize() 
    {
      if (low>high) 
	StepDown(low);
      
      if (low>high) 
	StepUp(high);
    }

  void LowInc() 
    { 
      low=StepUp(low);
      Normalize();
    }

  void LowDec() 
    { 
      low=StepDown(low);
      Normalize();
    }

  void HighInc() 
    { 
      high=StepUp(high);
      Normalize();
    }

  void HighDec() 
    { 
      high=StepDown(high);
      Normalize();
    }
};


/*******************************************************************/
struct BoolControl:public AControl {
  boolean isOn;
 
  boolean Toggle() { isOn=!isOn; return isOn; }  
  void Set() { isOn=true; }
  void Clear() { isOn=false; }
};


/*******************************************************************/
struct Controls { 
  IntControl Attenuation;
  IntControl VPosition;
  IntControl Sample_Rate;
  IntControl FreqLabOffset;

  RangeControl FreqRange;

  BoolControl LogXScale;
  BoolControl LogYScale;  
  
  Controls();

  void Set(const globalConfig& config);
  void Get(globalConfig& config);

  void Normalize();
};

/*******************************************************************/
