/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* control implementation                                                 */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: controls.cc,v 0.2 1995/04/15 05:43:57 drewvel Exp $


/*******************************************************************/
#include "controls.h"


/*******************************************************************/
Controls::Controls()
{
  Attenuation.Name("atten.");
  Attenuation.val=1;  
  Attenuation.step=1;

  VPosition.Name("v. position");
  VPosition.val=0;
  VPosition.step=1;

  FreqLabOffset.Name("freq. offset");
  FreqLabOffset.step=3;

  Sample_Rate.Name("sample rate");
  Sample_Rate.val=22050;

  FreqRange.Name("freq. range");
  FreqRange.step=64;
  FreqRange.SetLow(64);
  FreqRange.SetHigh(256);
  
  LogXScale.Set();
  LogYScale.Set();  
}


/*******************************************************************/
void Controls::Set(const globalConfig& config)
{
  Attenuation=config.Attenuation.val;
  Attenuation.min=Attenuation.max=1;

  VPosition=config.VPos.val; 
  
  FreqLabOffset=config.FreqLabelOffset.val;

  Sample_Rate=config.SampleRate.val;
  Sample_Rate.step=256;

  FreqRange.step=config.RangeInc.val;
  FreqRange.min=0;
  FreqRange.max=Sample_Rate.val/2;
  FreqRange.SetLow(config.LowFreq.val);
  FreqRange.SetHigh(config.HighFreq.val);
  
  if (config.LogScale.val) LogYScale.Set();
  else LogYScale.Clear();

  if (config.LogFreqScale.val) LogXScale.Set();
  else LogXScale.Clear();

  Normalize();
}


/*******************************************************************/
void Controls::Get(globalConfig& config)
{
  config.Attenuation.val=Attenuation.val;
  config.VPos.val=VPosition.val;
  config.SampleRate.val=Sample_Rate.val;

  config.LowFreq.val=FreqRange.low;
  config.HighFreq.val=FreqRange.high;
  config.RangeInc.val=FreqRange.step;

  config.LogScale.val=LogYScale.isOn;
  config.LogFreqScale.val=LogXScale.isOn;  
  config.FreqLabelOffset.val=FreqLabOffset.val;
}


/*******************************************************************/
void Controls::Normalize()
{  
  FreqRange.max=Sample_Rate.val/2;
  if (FreqRange.low>=FreqRange.high) FreqRange.high=FreqRange.max;
}

/*******************************************************************/
