/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* spectrum analyzer class interface                                      */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: analyzer.h,v 0.14 1995/05/02 16:02:14 drewvel Exp $             

#ifndef __ANALYZERH_INC
#define __ANALYZERH_INC

#include "configuration.h"
#include "signal.h"
#include "display.h"

#define ENDMESSAGE "<click!>"

struct globalConfig;

/*******************************************************************/
/* Spectrum Analyzer Class */
class SpectrumAnalyzer {
private:
  char fname[128];
  Signal *signal;
  Display *display;
  int DisplayNum;
  int sizescale;

  int bufsize, fbufsize;
  int sigfd;
  boolean buffer_allocated;
  sample8 *buffer8;
  sample16 *buffer16;
  real *sigbuf, *workbuf;
  boolean done;
  int atten_inc;
  float sqrarg;
  
  void AllocBuffer();
  void DestroyBuffer();

  void AllocDisplay(int type, int scr);
  void FreeDisplay();
  void ChangeDisplay(int type, int scr);

  inline boolean ProcessKeys();

//  inline void fft(float [], int, int);
//  inline void spectrum(real p[], int m, int k, int ovrlap);

  void AutoCalibrate();

  void UpdateFrequencies();

  void WriteOptions(globalConfig& config, char *fname);
  
public:
  int dbScale;

  SpectrumAnalyzer(int DBScale,
		   Signal *theSignal=NULL, 
		   int displaynum=1,
		   int sampbufsize=0); 
  ~SpectrumAnalyzer();
  
  void SetSignal(Signal&);
  void SetDisplay(Display&);
  
  void Show();
  void UnShow();
  
  void Analyze();
};
/*******************************************************************/

#endif __ANALYZERH_INC
