/********************************************/
/** NIST Speech Header Resources (SPHERE)  **/
/** Release 1.5 (beta)                     **/
/** Stan Janet (stan@jaguar.ncsl.nist.gov) **/
/** October 1990                           **/
/********************************************/

/* File: header.h */

#define TRUE			1
#define FALSE			0

#define MAXFIELDS		8000

#define FPNULL			((FILE *) NULL)
#define CNULL			((char *) NULL)
#define INULL			((int *) NULL)
#define LNULL			((long *) NULL)
#define FNULL			((struct field_t *) NULL)
#define FVNULL			((struct field_t **) NULL)
#define HDRNULL			((struct header_t *) NULL)

#define T_INTEGER		0
#define T_REAL			1
#define T_STRING		2

#define N_STDFIELDS		11

#define ERROR_EXIT_STATUS	1

struct field_t {
	int type;
	char *name;
	char *data;
	int datalen;
	char *comment;
};

struct header_t {
	int fc;
	struct field_t **fv;
};
/********************************************/
/** NIST Speech Header Resources (SPHERE)  **/
/** Release 1.5 (beta)                     **/
/** Stan Janet (stan@jaguar.ncsl.nist.gov) **/
/** October 1990                           **/
/********************************************/

/* File: functions.h */

/* User library functions */

struct header_t *sp_open_header(register FILE *fp, int parse_flag,
				char **error);
struct header_t *sp_create_header();
int sp_close_header(register struct header_t *h);

FILE *sp_get_fp();
int sp_set_fp();

int sp_get_hbytes();
int sp_get_nfields(struct header_t *h);
int sp_get_fieldnames(struct header_t *h, int n, char *v[]);

int sp_print_lines(struct header_t *h, register FILE *fp);
int sp_format_lines(struct header_t *h, register FILE *fp);
int sp_fpcopy(register FILE *fp, register FILE *outfp);

int sp_get_field(struct header_t *h, char *name, int *type, int *size);
int sp_get_data(struct header_t *h, char *name, char *buf, int *len);
int sp_get_type(struct header_t *h, char *name);
int sp_get_size(struct header_t *h, char *name);

int sp_clear_fields(register struct header_t *h);
int sp_add_field(struct header_t *h, char *name, int type, char *p);
int sp_delete_field(struct header_t *h, char *name);
int sp_change_field(struct header_t *h, char *name, int type, char *p);

int sp_is_std();

extern char *std_fields[];

int sp_set_dealloc(int n);
int sp_get_dealloc();

