/* DFT.H - light weight dft header File
 *------------------------------------------------------------*
 * HISTORY
 * 19-Mar-88  Fil Alleva (faa) at Carnegie-Mellon University
 *	Changed ps_flag to flags and added defines and macros for
 *	interpreting the flags field.
 *
 *  2-Oct-87  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added frame_samp_size field to dft_hdr_t.
 *	Bumped version number to 4.
 *
 *  4-Nov-86  Fil Alleva (faa) at Carnegie-Mellon University
 *	Author.
 *
 */

#ifndef _DFT_
#define _DFT_

#include <sys/types.h>

#define DFT_HDR_VERSION		4

#define DFT_DEFAULT_NCOEFF	128
#define DFT_DEFAULT_BPC		2
#define DFT_MAGIC		92158


struct dft_hdr {
    long	header_byte_size;
    long	version;
    long	frame_samp_incr;
    long	frame_count;
    long	ncoeff;
    long	byte_per_coeff;
    long	dbmax;
    long	magic;
    long	flags;			/* (v3) */
    long	frame_samp_size;	/* (v4) No. of samples per frame */
};
typedef struct dft_hdr dft_hdr_t;

typedef struct _async {
    long	idx;		/* ADC Sample index */
    short	cnt;		/* ADC Sample count */
    short	udef;		/* user defined */
} async_t;

/* FLAG bits
 */
#define ASYNC_FB		1	/* When this is an asynchronous */
#define FLOAT_FB		2	/* When the values are floats */
#define DOUBLE_FB		4	/* When the values are doubles */
#define COMPLEX_FB		8	/* When the values are complex */

#define IS_DFT_FLOAT(hp)	((hp)->flags & FLOAT_FB)
#define IS_DFT_DOUBLE(hp)	((hp)->flags & DOUBLE_FB)
#define IS_DFT_COMPLEX(hp)	((hp)->flags & COMPLEX_FB)
#define IS_DFT_ASYNC(hp)	((hp)->flags & ASYNC_FB)

#endif
