/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sound_list.h"
#include "state.h"

#include <sys/types.h>
#include <sys/stat.h>


Sound   *tail = NULL;
Sound   *sounds = NULL;
Sound   *current_sound = NULL;

static int		_all_play = 1;

/********************************************************************
 * Add a sound to the list of sounds we have.
 */
void sound_list_append(char *s)
{
	struct stat	buf;
	Sound		*snd = (Sound *) malloc(sizeof(Sound));

	if (state.debug)
		printf("%s: appeding '%s' to the sound list\n", state.program_name, s);

	snd->sound_name = malloc(strlen(s) + 1);
	strcpy(snd->sound_name, s);
	snd->sound_size = 0;
	snd->prev = NULL;
	snd->next = NULL;

	/*
	 * See if we can't find this sound locally
	 */
	if (stat(s, &buf) == 0)
	{
		snd->sound_size = buf.st_size;
		snd->sound_flow = Use_flow;
		_all_play = 0;
	}
	else
	{
		snd->sound_flow = Use_play;
	}

	/*
	 * Add the sound to the list
	 */
	if (tail)
	{
		snd->prev = tail;
		tail->next = snd;
		tail = snd;
	}
	else
	{
		tail = sounds = snd;
	}
}


/********************************************************************
 * Return the next sound to be played
 */
Sound *next_sound()
{
	if (current_sound)
		current_sound = current_sound->next;
	else
		current_sound = sounds;
	return current_sound;
}


/********************************************************************
 * Return the previous sound
 */
Sound *previous_sound()
{
	if (current_sound)
		current_sound = current_sound->prev;
	else
		current_sound = tail;
	return current_sound;
}


/********************************************************************
 * Let the caller know if there are any local files that need to be played
 */
int all_play()
{
	return _all_play;
}


