/* server.h - Definitions for RPTP server maintenance.  */

/* 
 * Copyright (C) 1993-95 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _server_h
#define _server_h

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "buffer.h"

typedef struct _server
{
    struct _server *next;
    struct sockaddr_in sin;
}
SERVER;

extern BUFFER *server_list;
extern SERVER *servers;

#ifdef __STDC__
extern void server_read (char *filename);
extern void server_reread (char *filename);
extern void server_stat (char *filename);
#else
extern void server_read ( /* char *filename */ );
extern void server_reread ( /* char *filename */ );
extern void server_stat ( /* char *filename */ );
#endif

#endif /* _server_h */
