/* radio.c 
 * the main magody
 * gideon le grange, 1994
 * there is no change history here, since the whole file was 
 * rewritten from scratch on 1994-11-22 */

#define NameLen     10
#define NumStations 10 
#define DefaultPort 0x30c
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "radio.h"
#include "priv.h"
#include "config.h"
#include "card.h"

station stations[NumStations];
int used=0;
char *myname;
float MinFreq=87.000;
float MaxFreq=109.000;
float DefaultFreq=0.0;
int   LocalConf=1;

int i,err;
int found=0;

void main(int argc, char **argv)
{
   myname=argv[0];

   if (strlen(ttyname(0))!=9)
     {
	printf("%s : %s must be run from the console\n",myname,myname);
	exit(-1);
     }
   
   yyin=fopen("/etc/radio.conf","r");
   if (yyin==NULL)
     {
	printf("%s : Error opening configuration file /etc/radio.conf\n",myname);
	exit(-1);
     }
   yylex();
   /* ok, now ve hav ze station info */

   RadioBase=DefaultPort;
   /* first ask for the radio track ports */
   err=get_io_privs(RadioBase);
   if (err!=0) 
     {
	printf("%s : %s needs IO permissions. Run %s setuid root\n",myname,myname,myname);
        exit(-1);
     }
   /* now give up root */
   give_up_root();
   
   if (argc!=2) 
     {
	printf("RadioTrack control program %s\nGideon le Grange, 1994\n",version);
	printf("%s usage: %s on | off | + | - | <channel> | <freq>\n",myname,myname);
	exit(-1);
     }
   else
     {
	if (strcmp(argv[1],"on")==0) 
	  {
	     if ((DefaultFreq<MinFreq) || (DefaultFreq>MaxFreq))
	       {
		  printf("%s : Invalid default frequency\n",myname);
		  exit(-1);
	       }
	     else
	       {
		  Tune(DefaultFreq);
		  exit(0);
	       }
	  }
	if (strcmp(argv[1],"off")==0) 
	  {
	     CardOff();
	     exit(0);
	  }
	if (strcmp(argv[1],"-")==0)
	  {
	     VolumeDown();
	     exit(0);
	  }
	if (strcmp(argv[1],"+")==0)
	  {
	     VolumeUp();
	     exit(0);
	  }
	/* ok, so it is channel name */
        for (i=0; i<used; ++i)
	  {
	     if (strcmp(argv[1],stations[i].name)==0)
	       {
		  Tune(stations[i].freq);
		  exit(0);
	       }
	  }
	  DefaultFreq=0.0;
	  sscanf(argv[1],"%f",&DefaultFreq);
	  if ((DefaultFreq<MinFreq) || (DefaultFreq>MaxFreq))
	   {
	     printf("%s : Invalid frequency or channel %s\n",myname,argv[1]);        
	     exit(-1);
	   }
	  else
	   {
	     Tune(DefaultFreq);
	     exit(0);
	   }
     }
}
