/* config.l  
 * grammar for lex scanner
 * gideon le grange, 1994
 * scanner to scan radio.conf config file 
 * some say this is overkill, but i think the extendability
 * makes it worth the trouble 
 * 1994-11-21 : done
 */
 
letter  [A-Za-z0-9]
digit   [0-9] 
ws      [ \t]+
name    {letter}+
freq    {digit}+"."{digit}+
port    0x{letter}+

%{ 
/* code to parse comes here */

#include <string.h> 
#include <stdlib.h>
#include "radio.h"
#include "card.h"

char*   delims=" \t";
char*  token;

int     num_lines=1;

void Station(char* text)
{
  char*  name;
  float  freq;

  token=(char*)strtok(text,delims);  /* swallow "station" */
  name=(char*)strtok(NULL,delims);   /* get station name */
  sscanf((char*)strtok(NULL,delims),"%f",&freq);   /* get station frequency */
  if (used<NumStations)
  {
      strncpy(stations[used].name,name,NameLen);
      if ((freq<MinFreq) || (freq>MaxFreq))
      {
          printf("%s : Invalid frequency in configuration file line %d\n",myname,num_lines);
          exit(-1);
      }
      stations[used].freq=freq;
      used++;
  }
}

void DefaultN(char* text)
{
  int i;
  int found=0;
  char* name;
 
  token=(char*)strtok(text,delims);
  name=(char*)strtok(NULL,delims);

  for (i=0; i<used; ++i)
  {
     if (strcmp(name,stations[i].name)==0)
     {
      DefaultFreq=stations[i].freq;
      if ((DefaultFreq<MinFreq) || (DefaultFreq>MaxFreq))
      {
      /* if this code ever executes I'll be very surprised */
          printf("%s : Invalid default frequency in configuration file line %d\n",myname,num_lines);
          exit(-1);
      }
	found=1;
     }
     if (found)
     {
        i=used;
     }
  }
  if (found==0) 
  {
     printf("%s : Invalid default station in configuration file line %d\n",myname,num_lines);
     exit(-1);
  }
}

void DefaultF(char* text)
{
  float freq;
  
  token=(char*)strtok(text,delims);
  sscanf((char*)strtok(NULL,delims),"%f",&freq);
  DefaultFreq=freq;
  if ((DefaultFreq<MinFreq) || (DefaultFreq>MaxFreq))
  {
      printf("%s : Invalid default frequency in configuration file line %d\n",myname,num_lines);
      exit(-1);
  }
}

void Port(char* text)
{
  unsigned int port;
  
  token=(char*)strtok(text,delims);  /* swallow "port" */
  sscanf((char*)strtok(NULL,delims),"%x",&port);   /* get port number */
  RadioBase=port;
  if ((RadioBase!=0x30c) && (RadioBase!=0x20c))
  {
     printf("%s : Invalid base port in configuration file line %d\n",myname,num_lines);
     exit(-1);
  }
}
%}
/* now the rules */
%%

station{ws}{name}{ws}{freq}        Station(yytext);

default{ws}{name}                  DefaultN(yytext);

default{ws}{freq}                  DefaultF(yytext);

port{ws}{port}                     Port(yytext);

[#\;\!][^\n]*$                     

\n                                 num_lines++;

{ws}

.                                  { 
                                     printf("%s : Error in config file line %d",myname,num_lines);
				   }

%%

