# procedures for TMusic
#
#
#

# haltq
# 19940706 csh
#
# halt current song and don't allow q restart
#
proc haltq {} {
  global handhold songlist stoptheq
  if $handhold {
    help_haltq
  }

  # we set the flag to stop the q and then kill the song
  set stoptheq 1
  songkiller
}
# END haltq

# godir
# 19940703
#
# jump to a directory and set the library variable
proc godir ddir {
  global library

  cd $ddir
  set library [pwd]
}
# END godir

# restart
# 19940703 csh
#
# restart program by running new one and killing parent
#
proc restart {} {
  global program
  
#  set parm [winfo geometry .]

  # start new one right on top of ourselves (winfo won't work, must
  # use the wm command)
  exec $program -geometry [wm geometry .] &

  # hari-kari... note this should actually do a proper shutdown
  exit
}
# END restart

# songkiller
# 19940701 csh
#
# this procedure kills all the music players
#
proc songkiller {} {
  global gmod midi
  catch { exec killall gmod mp }
  .bottom.info configure -text "******IDLE******"
}
# END songkiller

# readsongs
# 19940628 csh
#
# read songs in current directory, insert into main listbox
proc readsongs {} {
  global library

  # clear the list
  .m.songlist delete 0 end

  # loop through the output of a standard UNIX dir command
  foreach i [exec ls -a [pwd]] {

    #### see if this is a directory
    if [file isdirectory $i] { 
      set i $i/ 
      #### make sure it isn't the current directory pointer
      if {$i != "./"} { 
        #### this little tricks makes the previous pointer first
        if {$i == "../"} { .m.songlist insert 0 $i 
        } else { .m.songlist insert 1 $i }
      }
    #### it's a file so put it at the end
    } else {
      .m.songlist insert end $i
    }
  }
}
#### END readsongs

#### qsong
#### 19940630 csh
####
#### queue a song or songs from the current selection
proc qsong { } {
  global songlist library
  set error 0

  foreach i [selection get] {
    #### set a conditional flag here
    set songok 1
    #### skip if we see the "." entry
    if {$i == "./"} {.m.songlist select clear; return}
    if {$i == "../"} { godir ".." ; readsongs ;return } 
    if {[file isdirectory $i]} { godir $i; readsongs; return}

    #### run through list searching for duplicates and ignore them
    foreach j $songlist {
      if {[string compare $i [file tail $j]] == 0} {
        set songok 0
      }
    }
    #### OK, the song was not already there so add it to the queue
    if $songok {lappend songlist [pwd]/$i}
  }

  #### now let's destroy any duplicates
  
  #### first, sort the list
  #### set songlist [lsort $songlist] 

  #### on second thought... what if you want more than one...

  .m.songlist select clear

  if {[winfo exists .sq]} { showq }
  
}
#### END qsong

#### listsongs
#### 19940629 csh
####
#### this is just a debugging procedure to list the current song queue
####
proc listsongs {} {
  global songlist

  set size [llength $songlist]
  for {set i 0} { $i < $size } { incr i } {
    puts "Song $i [lindex $songlist $i]"
  }
}

#### checksong
#### 19940703 csh
#### 19940706 csh added check for stoptheq
####
#### this procedure checks to see if tmusic is currently waiting on a
#### process.  tmusic waits ONLY on music programs so this is fairly
#### simple
####
proc checksong {} {
  global spid stoptheq

  if $stoptheq {
    return
  }

  set children "boggerslime"

  #### check to see if current song is still playing
  #### use catch to prevent race conditions and sync problems
  catch {set children [wait -nohang ]}
  if { $children == "" } {
    #### yep, go away for a second before checking again
    after 1000 checksong 
    return 0
  }
  
  #### OK... the song is finished playing so go see if there is another
  #### one to play
  playsong

}
#### END checksong


#### playsong
#### 19940630 csh
#
#### play a song if the queue is not empty and setup a background
#### operation to allow the queue to operate simultaneously with
#### the main program (poor man's thread routine)
#
proc playsong {} {
  global songlist gmod gmodopts midi midiopts midext modext

  set temp [llength $songlist]
  set stoptheq 0

  set modyes 0
  set midiyes 0

  if { $temp != 0 } {
    set i [lindex $songlist 0]
    set songlist [lreplace $songlist 0 0]
    .bottom.info configure -text "Playing: [file tail $i]"

    #### now the mess I call file identification...

    foreach j $modext {
      if { [string first $j $i] > -1 } { set modyes 1 ; set midiyes 0 }
    }

    if {$modyes != "1"} {
      foreach j $midext {
        if { [string first $j $i] > -1 } { set midiyes 1; set modyes 0 }
      }
    }

    if {$modyes} {set spid [exec $gmod $gmodopts $i >& /dev/null & ]}

    if {$midiyes} {
      set spid [exec $midi $midiopts $i >& /dev/null & ]
    }

    #### here we set something like an idle task to check for the
    #### completion of the song
    after 1000 checksong

    #### update the showq box if it's active
    if {[winfo exists .sq]} showq
    return
  }
  #### set the label on the main app window to show idle state
  .bottom.info configure -text "******IDLE******"

}
#### END playsong

#### updateshowq
#### 19940704 csh
####
proc updateshowq {} {
  global songlist

  .sq.songs delete 0 end
  foreach i $songlist {
    .sq.songs insert end [file tail $i]
  } 
  pack .sq.songs
}

#### showqkill 
#### 19940704
####
#### kill something from the show Q
####
proc showqkill {} {
  global songlist

  foreach i [selection get] {
    set index 0
    foreach j $songlist {
      #### test for match
      if {[string compare $i [file tail $j]] == 0} {
        #### yes, remove it from the song list and the listbox

        #### first remove the item from the songlist
        set songlist [lreplace $songlist $index $index]
        #### now take it from the listbox
        .sq.songs delete $index
        showq
      }
      incr index
    }
  }  

}
#### END showqkill

#### showq
#### 19940703 csh
####
#### open a toplevel list of items in the queue... does nothing yet...
####
proc showq {} {
  global songlist 

  set geo ""

  #### update instead of creating if showq already has a window
  if { [winfo exists .sq] } {
    updateshowq
    return
  }

  #### put new q window right on top of old one
  toplevel .sq -geometry $geo
  button .sq.kill -bd 1  -text "Remove" -command {showqkill}
  button .sq.exit -bd 1  -text Exit -command {destroy .sq}
  pack .sq.kill -side top -fill x
  pack .sq.exit -side bottom -fill x
  scrollbar .sq.scrollsongs  -bd 1 -command ".sq.songs yview" -width 0.5c
  listbox .sq.songs  -bd 1 -relief raised -yscrollcommand ".sq.scrollsongs set"
  pack .sq.songs -side left -fill both
  pack .sq.scrollsongs -side right -fill y

  ####
  #### now add the queue to the listbox
  ####
  foreach i $songlist {
    .sq.songs insert end [file tail $i]
  } 
}
#### END showq

