/**********************************************************************
These variables describe the sound device. The current settings are
for mono-soundblaster-original with 20khz sampling rate. Increasing
the sampling rate will increase the output quality. For instance 8khz
is telephone quality whereas 44khz is cd quality.
**********************************************************************/

unsigned int samplestereo = 0;
unsigned int samplesize = 8;
unsigned int samplerate = 20000;

/**********************************************************************
The following large arrays are basically optimisations which the
compiler cannot perform.  I have noticed speed increases of 150%
after adding these arrays! The total consumed space is under 32kb
which is acceptable given the speed increase.

The mixing routines will combine all channels into one 32-bit sum
but the soundblaster requires 8-bit data. The problem is resolved
by dividing the sum by the number of channels.  However divisions
are notoriously slow. The OutputMap array stores all possible sum
and output pairs. The mapping then becomes one memory read.

Using output maps has further benefits. The current program uses
linear mapping which sounds ok. However logarithmic mapping also
is possible. This means output can be "amplified" for small input
values and "muffled" for large output values. Logarithmic mapping
requires hefty maths, so precalculating the mapping helps playback.

Linear Output               .     Amplified Output
^                           .     ^
|            *              .     |      * * * * *
|          *                .     |    *  
|        *                  .     |  *
|      *                    .     | *
|    *                      .     | *
|  *                        .     |*
|*                          .     |*
+-----------------> Input   .     +-----------------> Input

**********************************************************************/

unsigned char OutputMap[8192];

/**********************************************************************
A channels volume changes during playback, necessitating the need
for realtime scaling of channel data. The algorithm multiplies the
channel data by the volume, then divides by the maximum volume of
64. The multiplication and division (shift) isnt fast enough. The
VolumeMap array contains 65 internal arrays for volumes 0-64. The
scaling then becomes one multiplication (shift), one addition and
one memory read.
**********************************************************************/

unsigned char VolumeMap[65][256];

/**********************************************************************
Finally writing data to /dev/dsp contains some overhead. Writing
one byte per write call seriously hurts performance. The solution
is precalculating and writing large buffers of data. The MixBuffer
array prestores upto 4096 data elements. The Voxware documentation
recommended this size.
**********************************************************************/

unsigned char MixBuffer[4096];
