/* Copyright (C) 1995 by Andrew Robinson */
#include <X11/Intrinsic.h>

struct s_infoShell
{
  Widget w;

  struct
    {
      Widget w;

      struct
	{
	  Widget w;
	  Widget nameLabel;
	  Widget typeLabel;
	} nameForm;

      struct
	{
	  Widget w;
	  Widget posNameLabel;
	  Widget posLabel;
	  Widget patNameLabel;
	  Widget patLabel;
	} positionForm;

      Widget fileLabel;

      struct
	{
	  Widget w;
	  Widget fileList;
	} fileView;

      Widget commentLabel;
      Widget commentText;

      Widget sampleLabel;

      struct
	{
	  Widget w;
	  Widget sampleList;
	} sampleView;

      struct
	{
	  Widget w;
	  Widget closeCommand;
	  Widget currentCommand;
	  Widget playCommand;
	  Widget addCommand;
	  Widget removeCommand;
	  Widget clearCommand;
	  Widget saveCommand;
	  Widget shuffleCommand;
	} commandBox;

    } infoPane;

  struct
    {
      Widget playAlert;
      Widget removeAlert;
    } infoAlerts;

};

struct s_topShell
{
  Widget w;

  struct
    {
      Widget w;

      Widget infoCommand;
      Widget optCommand;
      Widget trackCommand;
      Widget nextCommand;
      Widget previousCommand;
      Widget forwardCommand;
      Widget backCommand;
      Widget stopCommand;
      Widget quitCommand;
    } topBox;
};

struct s_selShell
{
  Widget w;
  Widget fileComp;
  Widget okAlert;
};

struct s_optShell
{
  Widget w;

  struct
    {
      Widget w;

      struct
	{
	  Widget w;
	  Widget loopBreakToggle;
	  Widget speed0Toggle;
	} playGroup;

      struct
	{
	  Widget w;
	  Widget fiftyhzToggle;
	  Widget palToggle;
	  Widget bpmToggle;
	  Widget extendedToggle;
	} loadGroup;

      struct
	{
	  Widget w;
	  Widget removeToggle;
	  Widget randomToggle;
	  Widget highlightToggle;
	  Widget absoluteToggle;
	} queueGroup;

      struct
	{
	  Widget w;
	  Widget closeButton;
	} otherGroup;

    } optBox;
};

struct s_trackShell
{
  Widget w;

  struct
  {
    Widget w;

    struct 
    {
      Widget w;

      struct
      {
	Widget w;
	Widget trackList;
      } trackBoard;

    } trackView;

    Widget closeCommand;

  } trackForm;
};

struct s_bitmaps
{
  Pixmap previousBitmap;
  Pixmap nextBitmap;
  Pixmap backBitmap;
  Pixmap forwardBitmap;
  Pixmap stopBitmap;
};

struct x_struct
{
  XtAppContext app_context;
  struct s_topShell topShell;
  struct s_infoShell infoShell;
  struct s_selShell selShell;
  struct s_optShell optShell;
  struct s_trackShell trackShell;
  struct s_bitmaps bitmaps;
  String sampleStrings[256];
  String *fileStrings;
  String *trackStrings;
  int nrTrackStrings;
  int nrTrackChannels;
  int nrFileStrings;
};
