/* Copyright (C) 1995 by Andrew Robinson */
/* This file is part of the GMOD package */

#ifndef USE_X
#ifndef USE_NCURSES

#include <termios.h>
#include <unistd.h>
#include <fcntl.h>

#include "defines.h"

void
terminal_set (int mode)
{
  static long old_flags;
  static struct termios old_termio;
  struct termios new_termio;

  if (mode == TERMINAL_RAW)
    {
      /* not really raw */
      old_flags = fcntl (0, F_GETFL);
      fcntl (0, F_SETFL, old_flags | O_NONBLOCK);
      tcgetattr (0, &old_termio);
      new_termio = old_termio;
      new_termio.c_lflag = 0;
      new_termio.c_cc[VTIME] = 0;
      new_termio.c_cc[VMIN] = 0;
      tcsetattr (0, TCSANOW, &new_termio);
    }
  else
    {
      fcntl (0, F_SETFL, old_flags);
      tcsetattr (0, TCSANOW, &old_termio);
    }
}

#endif
#endif
