
/* Copyright (C) 1995 by Andrew Robinson */
#ifdef USE_X
#include <stdio.h>
#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/List.h>
#include <Xfwf/Alert.h>
#include <Xfwf/FileComp.h>

#include "xstructs.h"
#include "xglobals.h"
#include "xprotos.h"

void
callback_unmap (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown (x_info.selShell.w);

  XtVaSetValues (x_info.infoShell.infoPane.commandBox.addCommand,
		 XtNsensitive, True, NULL);
  XtVaSetValues (x_info.infoShell.infoPane.commandBox.saveCommand,
		 XtNsensitive, True, NULL);
}

void
add_module (int add_place, char *filename)
{
  if (current_mod == x_info.nrFileStrings)
    current_mod++;

  x_info.nrFileStrings++;

  x_info.fileStrings =
    realloc (x_info.fileStrings, sizeof (String) * x_info.nrFileStrings);

  memmove (x_info.fileStrings + add_place + 1,
	   x_info.fileStrings + add_place,
	   (x_info.nrFileStrings - add_place - 1) * sizeof (String));

  x_info.fileStrings[add_place] = strdup (filename);
}

void
callback_select (Widget w, XtPointer client_data, XtPointer call_data)
{
  int add_place, nrStrings = x_info.nrFileStrings;
  XawListReturnStruct *list_ret;
  FILE *fp;
  char buffer[BUFSIZ];

  list_ret = XawListShowCurrent (x_info.infoShell.infoPane.fileView.fileList);

  add_place = list_ret->list_index;

  if (add_place == XAW_LIST_NONE)
    add_place = x_info.nrFileStrings - 1;

  if ((fp = fopen ((char *) call_data, "r")) == NULL)
    {
      /*
      create_popup (x_info.selShell.w, "Unable to open file");
*/
      create_popup (x_info.selShell.w, x_info.selShell.okAlert);
      return;
    }

  fgets (buffer, BUFSIZ, fp);

  if (!memcmp (buffer, "@(#)GMOD-PLAYLIST", 17))
    while (fgets (buffer, BUFSIZ, fp) != NULL)
      {
	buffer[strlen (buffer) - 1] = '\0';
	add_place++;
	add_module (add_place, buffer);
      }
  else
    {
      add_place++;
      add_module (add_place, (char *) call_data);
    }

  fclose (fp);

  XawListChange (x_info.infoShell.infoPane.fileView.fileList,
		 x_info.fileStrings, x_info.nrFileStrings, 0, True);

  if (list_ret->list_index != XAW_LIST_NONE)
    XawListHighlight (x_info.infoShell.infoPane.fileView.fileList,
		      add_place);

  if ((nrStrings == 0) && (x_info.nrFileStrings > 0))
    XtVaSetValues (x_info.infoShell.infoPane.fileView.fileList,
		   XtNsensitive, True, NULL);

  check_buttons ();
}

void
callback_save_ok (Widget w, XtPointer client_data, XtPointer call_data)
{
  FILE *fp;
  int i;

  if ((fp = fopen ((char *) call_data, "w")) == NULL)
    /*
    create_popup (x_info.selShell.w, "Unable to open file");
*/
    create_popup (x_info.selShell.w, x_info.selShell.okAlert);
  else
    {
      fprintf (fp, "@(#)GMOD-PLAYLIST\n");

      for (i = 0; i < x_info.nrFileStrings; i++)
	fprintf (fp, "%s\n", (x_info.fileStrings)[i]);

      fclose (fp);

      callback_unmap (w, (XtPointer) 0, (XtPointer) 0);
    }
}

void
SelClose (Widget w, XEvent *event, String *parms, Cardinal *nparms)
{
  callback_unmap (w, (XtPointer)0, (XtPointer)0);
}

void
create_request (void)
{
  static XtActionsRec selActionsTable[] =
  {
    {"selClose", (XtActionProc)SelClose}
  };

  x_info.selShell.w =
  XtVaCreatePopupShell ("selShell", topLevelShellWidgetClass,
			x_info.infoShell.w,
			XtNtitle, "Xgmod File Selector",
			XtNiconName, "Xgmod Selector",
			NULL);

  XtAppAddActions (x_info.app_context, selActionsTable, XtNumber(selActionsTable));

  XtOverrideTranslations (x_info.selShell.w,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: selClose()"));

  x_info.selShell.fileComp =
    XtVaCreateManagedWidget ("selFileComp", xfwffileCompleteWidgetClass,
			     x_info.selShell.w, NULL);

  x_info.selShell.okAlert =
    XtVaCreatePopupShell ("okAlert", xfwfAlertWidgetClass,
			  x_info.selShell.w,
			  XtVaTypedArg, XtNicon, XtRString, "ERROR", 6,
			  XtNmessage, "Unable to open file.",
			  NULL);

  XtOverrideTranslations (x_info.selShell.okAlert,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: alertClose()"));

  XtAddCallback (x_info.selShell.okAlert, XtNcallback, close_popup,
		 (XtPointer) 0);

}

#endif
