
/* Copyright (C) 1995 by Andrew Robinson */

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#ifdef USE_X
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/List.h>

#include <Xfwf/Toggle.h>

#include "xstructs.h"
#include "xglobals.h"
#include "xprotos.h"
#endif

#include "defines.h"
#include "structs.h"
#include "globals.h"

#ifdef USE_X

static int scroll_amount, top_margin;

void update_tracker (void)
{
  static char *notes[] = {"C-", "C#", "D-", "D#", "E-", "F-", "F#", "G-", "G#", "A-", "A#", "B-"};
  int pos = tune[actual_pos];
  int pattern, channel;
  int note, voice, octave;
  char note_str[5];
  Dimension height;

  for (pattern = 0; pattern < x_info.nrTrackStrings; pattern++)
    free (x_info.trackStrings[pattern]);

  x_info.trackStrings = realloc(x_info.trackStrings, sizeof(String) * pattern_len[pos]);

  for (pattern = 0; pattern < pattern_len[pos]; pattern++)
    x_info.trackStrings[pattern] = (String)malloc(x_info.nrTrackChannels * 4 + 7);

  for (pattern = 0; pattern < pattern_len[pos]; pattern++)
    {
      sprintf (x_info.trackStrings[pattern], "[%03d] ", pattern);

      for (channel = 0; channel < x_info.nrTrackChannels; channel++)
	{
	  voice = voice_table[pos][channel];
	  note = (*pattern_table[voice])[pattern].note;
	  
	  if (note == NOTE_STOP)
	    strcpy (note_str, "STO ");
	  else if ((note == 0) || (note > 127))
	    strcpy (note_str, "... ");
	  else
	    {
	      octave = note / 12;
	      note = note % 12;
	      sprintf(note_str, "%s%01d ", notes[note], octave);
	    }
	  strcat (x_info.trackStrings[pattern], note_str);
	}
    }
  x_info.nrTrackStrings = pattern_len[pos];
  XawListChange (x_info.trackShell.trackForm.trackView.trackBoard.trackList, x_info.trackStrings, pattern_len[pos], 0, True);
  XtVaGetValues (x_info.trackShell.trackForm.trackView.trackBoard.trackList, XtNheight, &height, NULL);
  scroll_amount = height / pattern_len[pos];
  XtVaGetValues (x_info.trackShell.trackForm.trackView.trackBoard.w, XtNheight, &height, NULL);
  top_margin = height /  2;
  top_margin -= (top_margin % scroll_amount);
  XtVaGetValues (x_info.trackShell.trackForm.trackView.trackBoard.trackList, XtNwidth, &height, NULL);
  XtVaSetValues (x_info.trackShell.trackForm.trackView.trackBoard.w, XtNwidth, height, NULL);
}
#endif

unsigned int
proc_input (void)
{
  unsigned int seq_input;
#ifdef USE_X
  char buffer[12];
  Boolean toggle_stat;
#endif

  if (read (seqfd, &seq_input, 4) == 4)
    {
      if ((seq_input & 0xff) == SEQ_ECHO)
	{
	  seq_input >>= 8;
	  switch (seq_input & 0xff)
	    {
	    case ECHO_MESSAGE:
	      actual_pos = (seq_input >> 16) & 0xff;
#ifdef USE_X
	      sprintf (buffer, "%03d", actual_pos);
	      XtVaSetValues (x_info.infoShell.infoPane.positionForm.posLabel,
			     XtNlabel, buffer, NULL);
	      sprintf (buffer, "%03d", (seq_input >> 8) & 0xff);
	      XtVaSetValues (x_info.infoShell.infoPane.positionForm.patLabel,
			     XtNlabel, buffer, NULL);
	      sprintf (buffer, "Pattern %03d", (seq_input >> 8) & 0xff);
	      XtVaSetValues (x_info.trackShell.w, XtNtitle, buffer, NULL);
	      update_tracker ();
#else
	      fprintf (stderr, "Position %03d, Pattern %03d\r",
		       actual_pos, (seq_input >> 8) & 0xff);
#endif
	      break;
#ifdef USE_X
	    case ECHO_SPEED0:
	      XtVaGetValues (x_info.optShell.optBox.playGroup.speed0Toggle,
			     XtNon, &toggle_stat, NULL);
	      if (toggle_stat == False)
		callback_top_next (NULL, 0, NULL);
	      break;
	    case ECHO_LOOP:
	      XtVaGetValues (x_info.optShell.optBox.playGroup.loopBreakToggle,
			     XtNon, &toggle_stat, NULL);
	      if (toggle_stat == True)
		callback_top_next (NULL, 0, NULL);
	      break;
	    case ECHO_PATTERN:
	      XawListUnhighlight (x_info.trackShell.trackForm.trackView.trackBoard.trackList);
	      XtVaSetValues (x_info.trackShell.trackForm.trackView.trackBoard.trackList, XtNy,
			     (Position)(top_margin - (seq_input >> 8) * scroll_amount), NULL);
	      XawListHighlight (x_info.trackShell.trackForm.trackView.trackBoard.trackList,
				seq_input >> 8);
	      break;
#endif
	    }
	}
      else
	seq_input = ECHO_NONE;
    }
  else
    seq_input = ECHO_NONE;

  return (seq_input);
}
