
/* Copyright (C) 1995 by Andrew Robinson */

/*
*	gmod.c	- Module player for GUS and Linux.
*		(C) Hannu Savolainen, 1993
*
*	NOTE!	This program doesn't try to be a complete module player.
*		It's just a too I used while developing the driver. In
*		addition it can be used as an example on programming
*		the VoxWare Sound Driver with GUS.
*/

/*
* Many modifications have been done by Andrew J. Robinson.
* Refer to the ChangeLog for details.
*/

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include <sys/ultrasound.h>

#include "commands.h"
#include "defines.h"
#include "structs.h"
#include "globals.h"
#include "protos.h"

static unsigned char s3m_extend_tab[] =
{CMD_INFO, CMD_GLISSANDO, CMD_FINETUNE, CMD_VIBRA_WAVE,	/* S0 S1 S2 S3 */
 CMD_TREMOLO_WAVE, CMD_INFO, CMD_INFO, CMD_INFO,	/* S4 S5 S6 S7 */
 CMD_SET_PAN, CMD_INFO, CMD_INFO, CMD_PATTERN_LOOP,	/* S8 S9 SA SB */
 CMD_CUT_NOTE, CMD_DELAY_NOTE, CMD_DELAY_PAT, CMD_INFO};	/* SC SD SE SF */

void
cvt_s3m_play (int channel, unsigned char *effect, unsigned char *parm)
{
  int tmp;

  switch (*effect)
    {
    case 0:
      break;
    case CMD_VOLSLIDE:
      if (*parm == 0)
	*parm = voices[channel].last_info;
      else
	voices[channel].last_info = *parm;

      if ((*parm > 0xf0) && (*parm < 0xff))
	{
	  *effect = CMD_FINEVOLDOWN;
	  *parm &= 0x0f;
	}
      else if (((*parm & 0x0f) == 0x0f) && ((*parm & 0xf0) > 0))
	{
	  *effect = CMD_FINEVOLUP;
	  *parm = (*parm >> 4) & 0x0f;
	}
      else if (((*parm & 0x0f) != 0) && ((*parm & 0xf0) != 0))
	*parm &= 0x0f;
      break;
    case CMD_SLIDEUP:
      if (*parm == 0)
	*parm = voices[channel].last_info;
      else
	voices[channel].last_info = *parm;

      if (*parm >= 0xf0)
	{
	  *effect = CMD_FINEPORTUP;
	  *parm &= 0x0f;
	}
      else if (*parm >= 0xe0)
	{			/* extra-fine slide, not really supported */
	  *effect = CMD_FINEPORTUP;
	  *parm &= 0x0f;
	  tmp = (int) (*parm) + voices[channel].fineslide_adj;
	  if (tmp >= 0)
	    {
	      voices[channel].fineslide_adj = tmp % 4;
	      *parm = tmp / 4;
	    }
	  else
	    {
	      voices[channel].fineslide_adj = (signed char) (tmp);
	      *parm = 0;
	    }
	}
      break;
    case CMD_SLIDEDOWN:
      if (*parm == 0)
	*parm = voices[channel].last_info;
      else
	voices[channel].last_info = *parm;

      if (*parm >= 0xf0)
	{
	  *effect = CMD_FINEPORTDOWN;
	  *parm &= 0x0f;
	}
      else if (*parm >= 0xe0)
	{			/* extra-fine slide, not really supported */
	  *effect = CMD_FINEPORTDOWN;
	  *parm &= 0x0f;
	  tmp = (int) (*parm) - voices[channel].fineslide_adj;
	  if (tmp >= 0)
	    {
	      voices[channel].fineslide_adj = -(tmp % 4);
	      *parm = tmp / 4;
	    }
	  else
	    {
	      voices[channel].fineslide_adj = (signed char) (-tmp);
	      *parm = 0;
	    }
	}
      break;
    case CMD_ARPEG2:
      if (*parm == 0)
	*parm = voices[channel].last_info;
      else
	voices[channel].last_info = *parm;

      *effect = CMD_ARPEG;
      break;
    case CMD_TREMOR:
    case CMD_VIBRAANDVOL:
    case CMD_PORTANDVOL:
    case CMD_SLIDETO:
    case CMD_VIBRATO:
    case CMD_RETRIGVOL:
      if (*parm == 0)
	*parm = voices[channel].last_info;
      else
	voices[channel].last_info = *parm;
      break;
    case CMD_BREAK:
      voices[channel].last_info = *parm;
      *parm = ((*parm >> 4) & 0x0f) * 10 + (*parm & 0x0f);
      break;
    case CMD_FINETUNE:
      voices[channel].last_info = *parm;
      *parm &= 0x0f;
      if (*parm >= 8)
	*parm -= 8;
      else
	*parm += 8;
      break;
    case CMD_GLOBAL_VOL:
      voices[channel].last_info = *parm;
      if (*parm > 0)
	*parm = (*parm * 4) - 1;
      break;
    case CMD_EXTENDED:
      voices[channel].last_info = *parm;
      *effect = s3m_extend_tab[(*parm & 0xf0) >> 4];
      *parm &= 0x0f;
      break;
    default:
      voices[channel].last_info = *parm;
    }

  if (*effect == CMD_INFO)
    {
      *effect = 0;
      *parm = 0;
    }
}

int
do_command (int channel, int command, int parm, int parm2, int note, int position, int pattern,
	    struct song_info *song_char, struct effect_info *effects)
  {
    int jump = 0;

    switch (command)
      {

      case CMD_NOP:;
	break;

      case CMD_ARPEG:
	if (parm)
	  set_arpeg (channel, parm);
	break;

      case CMD_JUMP:
	jump = MOVE_JUMP;
	effects->position = parm;
	effects->pattern = 0;
	break;

      case CMD_BREAK:
	jump = MOVE_BREAK;
	if (((position + 1) < song_char->songlength) &&
	    (parm < pattern_len[tune[position + 1]]))
	  effects->pattern = parm;
	else
	  effects->pattern = 0;
	break;

      case CMD_SET_TICKS:
	if (parm)
	  TICKS_PER_DIVISION (parm);
	else
	  {
#ifdef USE_X
	    sync_time ();
	    SEQ_ECHO_BACK (ECHO_SPEED0);
#else
	    jump = MOVE_EXIT;
#endif
	  }
	break;

      case CMD_SET_BPM:
	TEMPO (parm, song_char->clock_speed);
	break;

      case CMD_SLIDEUP:
	if (parm > 0)
	  {
	    set_slideto (channel, parm, song_char->highest_note, SLIDE_UP, song_char->type);
	  }
	break;

      case CMD_SLIDEDOWN:
	if (parm > 0)
	  {
	    set_slideto (channel, parm, song_char->lowest_note, SLIDE_DOWN, song_char->type);
	  }
	break;

      case CMD_SLIDETO:
	set_slideto (channel, parm, note, SLIDE_PORT, song_char->type);
	break;

      case CMD_SETOFFSET:
      case CMD_SETOFFSET_1024:
      case CMD_SETOFFSET_FINE:
	sync_time ();
	/* if there is no note, restart current note to prevent click */
	if (!note)
	  {
	    int vol = voices[channel].volume;

	    if (song_char->vol_type == VOL_LOG)
	      vol = vol_log_to_lin ((unsigned char) vol) / 2;
	    else
	      vol /= 2;

	    SEQ_START_NOTE (gus_dev, channel, voices[channel].note, vol);
	  }
	if (command == CMD_SETOFFSET)
	  {
	    GUS_VOICE_POS (gus_dev, channel, parm * 256);
	  }
	else if (command == CMD_SETOFFSET_1024)
	  {
	    GUS_VOICE_POS (gus_dev, channel, parm * 1024);
	  }
	else
	  {
	    GUS_VOICE_POS (gus_dev, channel, ((parm * 256) + parm2) * 4);
	  }
	break;

      case CMD_VIBRA_WAVE:
	if ((parm & 0x03) == 0x03)
	  parm -= 1;
	voices[channel].vibra_wave = parm;
	break;

      case CMD_TREMOLO_WAVE:
	if ((parm & 0x03) == 0x03)
	  parm -= 1;
	voices[channel].tremolo_wave = parm;
	break;

      case CMD_GLISSANDO:
	voices[channel].glissando = parm;
	break;

      case CMD_DELAY_PAT:
	effects->delay_notes = parm;
	break;

      case CMD_CUT_NOTE:
	voices[channel].cut_count = parm;
	break;

      case CMD_DELAY_NOTE:
	if (parm == 0)
	  parm = 1;
	voices[channel].delay_count = parm;
	break;

      case CMD_PATTERN_LOOP:
	if (parm == 0)
	  voices[channel].pattern = pattern;
	else
	  {
	    effects->loop_chan = channel;
	    if (voices[channel].loop_times == 0)
	      {
		voices[channel].loop_times = parm;
		effects->pattern = voices[channel].pattern;
		jump = MOVE_LOOP;
	      }
	    else if (--voices[channel].loop_times > 0)
	      {
		effects->pattern = voices[channel].pattern;
		jump = MOVE_LOOP;
	      }
	  }
	break;

      case CMD_RETRIGGER:
	voices[channel].retrigger = parm;
	voices[channel].retrig_vol = 0;
	break;

      case CMD_RETRIGVOL:
	voices[channel].retrigger = parm & 0x0f;
	voices[channel].retrig_vol = (parm >> 4) & 0x0f;
	break;

      case CMD_FINEVOLUP:
	voices[channel].finevol = MY_TRUE;
	voices[channel].volslide = parm * VOL_SLIDE_RATE;
	break;

      case CMD_FINEVOLDOWN:
	voices[channel].finevol = MY_TRUE;
	voices[channel].volslide = -parm * VOL_SLIDE_RATE;
	break;

      case CMD_FINEPORTUP:
	if (parm > 0)
	  set_slideto (channel, parm, song_char->highest_note, SLIDE_ONCE, song_char->type);
	break;

      case CMD_FINEPORTDOWN:
	if (parm > 0)
	  set_slideto (channel, parm, song_char->lowest_note, SLIDE_ONCE, song_char->type);
	break;

      case CMD_VOLSLIDE:
	set_volslide (channel, parm, song_char->type);
	break;

      case CMD_PORTANDVOL:
	set_volslide (channel, parm, song_char->type);
	voices[channel].slide_pitch = 1;
	break;

      case CMD_VIBRATO:
	set_vibrato (channel, parm);
	break;

      case CMD_VIBRAANDVOL:
	set_vibrato (channel, 0);
	set_volslide (channel, parm, song_char->type);
	break;

      case CMD_TREMOLO:
	set_tremolo (channel, parm);
	break;

      case CMD_TREMOR:
	set_tremor (channel, parm);
	break;

      default:
	/* printf ("Command %x %02x\n", pat->command, pat->parm1); */
      }

    return jump;
  }

/* do_pre_command:  Commands executed before note is started */

void
do_pre_command (int channel, int command, int parm, int note,
		struct song_info *song_char, struct options_info *options)
{
  int tmp_int;

  switch (command)
    {
    case 0:
    case CMD_NOP:
      break;

    case CMD_FINETUNE:
      parm &= 0x0f;
      if (sample_ok[voices[channel].sample])
	{
	  if (parm <= 7)
	    samples[voices[channel].sample].finetune = 12.5 * parm;
	  else
	    samples[voices[channel].sample].finetune = 12.5 * (parm - 16);
	}
      break;

    case CMD_SET_PAN:
      if (!note)
	tmp_int = PAN_HARDWARE;
      else
	tmp_int = PAN_NO_HARDWARE;
      set_panning (channel, (parm & 0x0f) * 17 - 128, tmp_int, options->pan_factor);
      break;

    case CMD_VOLUME:
      {
	int vol = parm;

	if (voices[channel].volume != vol)
	  {
	    voices[channel].volume = vol;
	    if (!note)
	      {
		if (song_char->vol_type == VOL_LOG)
		  vol = vol_log_to_lin ((unsigned char) vol) / 2;
		else
		  vol /= 2;
		sync_time ();
		SEQ_START_NOTE (gus_dev, channel, 255, vol);
	      }
	  }
      }
      break;
    case CMD_GLOBAL_VOL:
      sync_time ();
      for (tmp_int = 0; tmp_int < song_char->nr_channels; tmp_int++)
#ifdef LINEAR_VOLUME
	SEQ_MAIN_VOLUME (gus_dev, channel, (options->main_volume * parm) / (255 * 2));
#else
	SEQ_EXPRESSION (gus_dev, channel, options->main_volume * parm / 255);
#endif

      break;
    }
}

int
play_note (int channel, int position, int pattern, struct note_info *pat,
	   struct song_info *song_char, struct effect_info *effects,
	   struct options_info *options)
{
  int jump = 0;
  int sample = pat->sample, note = pat->note, vol, tmp_int;
  int old_sample, old_arpeg, old_vibra, old_tremolo, old_tremor;
  unsigned char command = pat->command[1], param = pat->parm1[1];

  if (song_char->type == MODULE_S3M)
    cvt_s3m_play (channel, &command, &param);

  old_arpeg = voices[channel].arpeg_num;
  old_vibra = voices[channel].vibra_rate;
  old_tremolo = voices[channel].tremolo;
  old_tremor = voices[channel].tremor;

  if (voices[channel].slide_pitch == SLIDE_OFF)
    {
      sync_time ();
      GUS_VOICEOFF (gus_dev, channel);
      voices[channel].slide_pitch = 0;
    }

  if ((command != CMD_NOP) || (pat->note != 0))
    {
      voices[channel].arpeg_num = 0;
      voices[channel].vibra_rate = 0;
      voices[channel].tremolo = 0;
      voices[channel].slide_pitch = 0;
      voices[channel].volslide = 0;
      voices[channel].retrigger = 0;
      voices[channel].cut_count = 0;
      voices[channel].delay_count = 0;
      voices[channel].tremor = 0;
    }
  old_sample = voices[channel].sample;

  /* A sample with no note resets the volume to its default, but should not */
  /* retrigger the note.  This really isn't possible with the current */
  /* drivers if the sample changes, so the note is retriggered on a sample */
  /* change */

  if (sample)
    {
      voices[channel].sample = --sample;

      if (sample_ok[sample] && (old_sample != sample))
	{
	  sync_time ();
	  SEQ_SET_PATCH (gus_dev, channel, sample);
	}

      if (!note || (pat->command[0] == CMD_SLIDETO) ||
	  (command == CMD_SLIDETO))
	{
	  if (sample_ok[sample])
	    vol = samples[sample].volume;
	  else
	    vol = 0;

	  if (old_sample != sample)
	    {
	      sync_time ();
	      SEQ_START_NOTE (gus_dev, channel, voices[channel].note, 0);
	      voices[channel].volume = 0;
	    }

	  if ((voices[channel].volume != vol) &&
	      (pat->command[0] != CMD_VOLUME) &&
	      (command != CMD_VOLUME))
	    {
	      voices[channel].volume = vol;

	      if (song_char->vol_type == VOL_LOG)
		vol = vol_log_to_lin ((unsigned char) vol) / 2;
	      else
		vol /= 2;
	      sync_time ();
	      SEQ_START_NOTE (gus_dev, channel, 255, vol);
	    }
	}
      else
	{
	  if (sample_ok[sample])
	    voices[channel].volume = samples[sample].volume;
	  else
	    voices[channel].volume = 0;
	}
    }
  else
    sample = voices[channel].sample;

  if (note == NOTE_STOP)
    {
      sync_time ();
      GUS_VOICEOFF (gus_dev, channel);
      note = 0;
    }

  /* If portamento is used, force immediate pan or volume change */

  if ((pat->command[0] == CMD_SLIDETO) || (command == CMD_SLIDETO))
    tmp_int = 0;
  else
    tmp_int = pat->note;

  do_pre_command (channel, pat->command[0], pat->parm1[0], tmp_int,
		  song_char, options);
  do_pre_command (channel, command, param, tmp_int,
		  song_char, options);

  if (note && (pat->command[0] != CMD_SLIDETO) &&
      (command != CMD_SLIDETO))
    {
      sync_time ();

      if (sample_ok[sample])
	{
	  if (voices[channel].pitchbender || old_arpeg || old_vibra ||
	      (samples[sample].finetune != voices[channel].finetune))
	    {
	      /* correct for rounding by the driver */
	      tmp_int = samples[sample].finetune;
	      if (tmp_int >= 0)
		tmp_int++;
	      else
		tmp_int--;

	      if ((pat->command[0] != CMD_DELAY_NOTE) &&
		  (command != CMD_DELAY_NOTE))
		SEQ_PITCHBEND (gus_dev, channel, tmp_int);

	      voices[channel].pitchbender = 0;
	      voices[channel].finetune = samples[sample].finetune;
	      old_arpeg = 0;
	      old_vibra = 0;
	    }

	  vol = voices[channel].volume;

	  if (song_char->vol_type == VOL_LOG)
	    vol = vol_log_to_lin ((unsigned char) vol) / 2;
	  else
	    vol /= 2;

	  if ((pat->command[0] != CMD_DELAY_NOTE) &&
	      (command != CMD_DELAY_NOTE))
	    SEQ_START_NOTE (gus_dev, channel, note, vol);

	  voices[channel].note = note;
	  voices[channel].slide_period = period_table[note - NOTE_BASE] * 256;
	  voices[channel].fineslide_adj = 0;

	  if (voices[channel].vibra_wave <= 3)
	    voices[channel].vibra_position = 0;
	  if (voices[channel].tremolo_wave <= 3)
	    voices[channel].tremolo_position = 0;
	}
      else
	GUS_VOICEOFF (gus_dev, channel);
    }

  jump = do_command (channel, pat->command[0], pat->parm1[0], pat->parm2[0], pat->note,
		     position, pattern, song_char, effects);
  jump |= do_command (channel, command, param, pat->parm2[1], pat->note,
		      position, pattern, song_char, effects);

  if (((old_arpeg && !voices[channel].arpeg_num) ||
       (old_vibra && !voices[channel].vibra_rate)) &&
      !pat->note)
    {
      /* correct for rounding by the driver */
      tmp_int = voices[channel].pitchbender + voices[channel].finetune;
      if (tmp_int >= 0)
	tmp_int++;
      else
	tmp_int--;

      sync_time ();
      SEQ_PITCHBEND (gus_dev, channel, tmp_int);
    }

  if (((old_tremolo && !voices[channel].tremolo) ||
       (old_tremor && !voices[channel].tremor)) &&
      (!pat->note || (pat->command[0] == CMD_SLIDETO) ||
       (command == CMD_SLIDETO)))
    {
      if (old_tremor && !voices[channel].tremor)
	voices[channel].volume = voices[channel].trem_volume;

      vol = voices[channel].volume;
      if (song_char->vol_type == VOL_LOG)
	vol = vol_log_to_lin ((unsigned char) vol) / 2;
      else
	vol /= 2;

      sync_time ();
      SEQ_START_NOTE (gus_dev, channel, 255, vol);
    }

  return jump;
}
