
/* Copyright (C) 1995 by Andrew Robinson */
/*
*	gmod.c	- Module player for GUS and Linux.
*		(C) Hannu Savolainen, 1993
*
*	NOTE!	This program doesn't try to be a complete module player.
*		It's just a too I used while developing the driver. In
*		addition it can be used as an example on programming
*		the VoxWare Sound Driver with GUS.
*/

/*
* Many modifications have been done by Andrew J. Robinson.
* Refer to the ChangeLog for details.
*/

#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include <sys/ultrasound.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef USE_X
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "xdefines.h"
#include "xstructs.h"
#include "xglobals.h"
#include "xprotos.h"
#endif

#include "defines.h"
#include "structs.h"
#include "globals.h"
#include "protos.h"

int
play_module (int start_position, struct song_info *song_char,
	     struct options_info options)
{
  int i, position, pat_start = 0, extra_ticks, jump_to_pos = 0, pan, saved_position = 0;
  struct effect_info effects =
  {0, 0, 0, 0};
  int voice;
  /*
  char message[80];
*/
  unsigned int seq_input = ECHO_NONE;
#ifndef USE_X
  fd_set read_fds;
#endif
  static double saved_td;
  static int saved_tpd;
  char played[MAX_POSITION];

  /*
  init_message_q ();
*/

  init_voices ();

  if (start_position == 0)
    for (i = 0; i < song_char->songlength; i++)
      played[i] = MY_FALSE;

  SEQ_START_TIMER ();

  for (i = 0; i < song_char->nr_channels; i++)
    {
      SEQ_BENDER_RANGE (gus_dev, i, 8191);
#ifdef LINEAR_VOLUME
      SEQ_EXPRESSION (gus_dev, i, 255);
      SEQ_MAIN_VOLUME (gus_dev, i, (options.main_volume * song_char->global_vol) / (255 * 2));
#else
      SEQ_EXPRESSION (gus_dev, i, options.main_volume * song_char->global_vol / 255);
      SEQ_MAIN_VOLUME (gus_dev, i, 127);
#endif
      pan = song_char->panning[i] * 2;
      if (pan > 127)
	pan = 127;
      else if (pan < -127)
	pan = -127;
      pan = (pan * options.pan_factor) / 100;
      SEQ_PANNING (gus_dev, i, pan);
      voices[i].panning = (signed char) pan;
      SEQ_PITCHBEND (gus_dev, i, 0);
    }

  next_time = 0.0;

  if (start_position == 0)
    {
      TICKS_PER_DIVISION (song_char->play_speed);
      TEMPO (song_char->tempo, song_char->clock_speed);
    }
  else
    {
      ticks_per_division = saved_tpd;
      tick_duration = saved_td;
    }

  this_time = 0.0;
  next_time += tick_duration;
  sync_time ();

  do
    {
      for (position = start_position; position < song_char->songlength; position++)
	{
	  int tick, pattern, channel, pos, go_to;


	  if ((played[position] == MY_TRUE) && !(jump_to_pos & MOVE_LOOP))
	    {
#ifdef USE_X
	      sync_time ();
	      SEQ_ECHO_BACK (ECHO_LOOP);
#else
	      if (options.loop_breaker == 1)
		{
		  position = song_char->songlength - 1;
		  continue;
		}
	      else
#endif
		for (i = 0; i < song_char->songlength; i++)
		  played[i] = MY_FALSE;
	    }

	  played[position] = MY_TRUE;
	  pos = tune[position];

	  if (pos == ORDER_STOP)
	    {
	      position = song_char->songlength - 1;
	      continue;
	    }
	  else if (pos == ORDER_SKIP)
	    continue;

	  /*
	  sprintf (message, "Position %03d, Pattern %03d\r", position, pos);
	  put_message (message, (unsigned long) next_time);
*/
	  sync_time ();
	  SEQ_ECHO_BACK ((((unsigned int) position << 16) & 0x00ff0000) |
			 (((unsigned int) pos << 8) & 0x0000ff00) |
			 ECHO_MESSAGE);

	  if (pattern_tempo[pos])
	    set_speed (pattern_tempo[pos], song_char->clock_speed);

	  jump_to_pos = 0;
	  for (pattern = pat_start; pattern < pattern_len[pos] && jump_to_pos == 0; pattern++)
	    {
	      /*
	      this_time = 0.0;
*/

#ifdef USE_X
	      sync_time ();
	      SEQ_ECHO_BACK(((unsigned int)pattern << 8) | ECHO_PATTERN);
#endif
	      for (channel = 0; channel < song_char->nr_channels; channel++)
		{
		  voice = voice_table[pos][channel];
		  if ((go_to = play_note (channel, position, pattern,
			       &(*pattern_table[voice])[pattern], song_char,
					  &effects, &options)) != 0)
		    jump_to_pos |= go_to;
		}

	      extra_ticks = ticks_per_division * effects.delay_notes;
	      effects.delay_notes = 0;

	      /* next_time += tick_duration; */
	      for (tick = 0; tick < ticks_per_division + extra_ticks; tick++)
		{
		  for (channel = 0; channel < song_char->nr_channels; channel++)
		    {
		      lets_play_voice (channel, &voices[channel], song_char,
				       tick);
		    }
		  next_time += tick_duration;
		}

	      if (stop_flag)
		jump_to_pos = MOVE_EXIT;
	      /*
	      else if (position_change)
		jump_to_pos = MOVE_FORWBACK;
*/
	    }			/* pattern */

	  pat_start = 0;

	  if (jump_to_pos & MOVE_LOOP)
	    {
	      pat_start = effects.pattern;
	      effects.pattern = 0;
	      position -= 1;
	    }
	  if (jump_to_pos & MOVE_JUMP)
	    {
	      pat_start = effects.pattern;
	      position = effects.position - 1;
	    }
	  if (jump_to_pos & MOVE_BREAK)
	    {
	      pat_start = effects.pattern;
	    }
	  if (jump_to_pos & MOVE_EXIT)
	    {
	      saved_position = position;
	      position = song_char->songlength - 1;
	    }

	  /*
	  next_time -= tick_duration;
	  sync_time ();
	  next_time += tick_duration;
*/

	  /*
	  if (position_change != 0)
	    jump_to_pos = MOVE_FORWBACK;

	  if (jump_to_pos & MOVE_FORWBACK)
	    {
	      position += (position_change - 1);
	      if (position < 0)
		position = 0;
	      position_change = 0;
	      message[0] = 'X';
	      while (message[0] != '\0')
		get_message (message, 0xffffffff);
	    }
*/
	}

      if (options.repeat)
	start_position = 0;
    }
  while (options.repeat && !stop_flag);

  if (!stop_flag)
    {
      sync_time ();

      for (i = 0; i < song_char->nr_channels; i++)
	SEQ_STOP_NOTE (gus_dev, i, 0, 127);

      next_time += 200;
      sync_time ();
    }

  do
    {
      if (!dump_enabled)
	{
	  ioctl (seqfd, SNDCTL_SEQ_RESET, 0);
	  _seqbufptr = 0;
	  dump_enabled = 1;
	}
      stop_all_channels (MY_TRUE);
    }
  while (!dump_enabled);

#ifdef USE_X
  set_inputs (INPUTS_WRITE, INPUTS_REMOVE);
#else
  FD_ZERO (&read_fds);
#endif

  seq_input = ECHO_NONE;
  do
    {
#ifdef USE_X
      callback_arg = INPUTS_X;

      while (callback_arg == INPUTS_X)
	XtAppProcessEvent (x_info.app_context, XtIMXEvent | XtIMAlternateInput);
#else
      FD_SET (0, &read_fds);
      FD_SET (seqfd, &read_fds);
      select (seqfd + 1, &read_fds, NULL, NULL, NULL);
#endif

#ifdef USE_X
      if (callback_arg == INPUTS_READ)
#else
      if (FD_ISSET (seqfd, &read_fds))
#endif
	seq_input = proc_input ();

#ifdef USE_X
      if (callback_arg == INPUTS_BUTTON)
	{
#else
      if (FD_ISSET (0, &read_fds))
	{
	  timer_handler (-1);
#endif
	  if (!dump_enabled)
	    {
	      dump_enabled = 1;
	      _seqbufptr = 0;
	      ioctl (seqfd, SNDCTL_SEQ_RESET, 0);
#ifdef USE_X
	      set_inputs (INPUTS_WRITE, INPUTS_ADD);
#endif
	      stop_all_channels (MY_TRUE);
#ifdef USE_X
	      set_inputs (INPUTS_WRITE, INPUTS_REMOVE);
#endif
	    }
	}
    }
  while (seq_input != ECHO_END);

#ifdef USE_X
  set_inputs (INPUTS_WRITE, INPUTS_ADD);
  XtVaSetValues (x_info.infoShell.infoPane.positionForm.posLabel,
		 XtNlabel, "END", NULL);
  XtVaSetValues (x_info.infoShell.infoPane.positionForm.patLabel,
		 XtNlabel, "END", NULL);
#endif

  if (stop_flag != STOP_FORWBACK)
    free_patterns (song_char->nr_samples);
  else
    {
      saved_tpd = ticks_per_division;
      saved_td = tick_duration;
    }

  return (saved_position);
}
