
/* Copyright (C) 1995 by Andrew Robinson */
#ifdef USE_X
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <Xfwf/Button.h>
#include <Xfwf/Toggle.h>
#include <Xfwf/Group.h>
#include <Xfwf/FileComp.h>

#include "xstructs.h"
#include "xglobals.h"

void
callback_opt (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown (x_info.optShell.w);
  XtVaSetValues (x_info.topShell.topBox.optCommand, XtNsensitive, True,
		 NULL);
}

void
callback_opt_full_on (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtVaSetValues (x_info.selShell.fileComp, XtNfollowLinks, XfwfFCAlways, NULL);
}

void
callback_opt_full_off (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtVaSetValues (x_info.selShell.fileComp, XtNfollowLinks, XfwfFCNever, NULL);
}

void
OptClose (Widget w, XEvent *event, String *parms, Cardinal *nparms)
{
  callback_opt (w, (XtPointer)0, (XtPointer)0);
}

void
create_opt (void)
{
  static XtActionsRec optActionsTable[] =
  {
    {"optClose", (XtActionProc)OptClose}
  };

  x_info.optShell.w =
  XtVaCreatePopupShell ("optShell", topLevelShellWidgetClass,
			x_info.topShell.w,
			XtNtitle, "Xgmod Options",
			XtNiconName, "Xgmod Options",
			NULL);

  XtAppAddActions (x_info.app_context, optActionsTable, XtNumber(optActionsTable));

  XtOverrideTranslations (x_info.optShell.w,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: optClose()"));

  x_info.optShell.optBox.w =
    XtVaCreateManagedWidget ("optBox", boxWidgetClass,
			     x_info.optShell.w,
			     NULL);

  x_info.optShell.optBox.playGroup.w =
    XtVaCreateManagedWidget ("playGroup", xfwfGroupWidgetClass,
			     x_info.optShell.optBox.w,
			     XtNlabel, "Play Options",
			     XtNselectionStyle, XfwfNoSelection,
			     NULL);

  x_info.optShell.optBox.loadGroup.w =
    XtVaCreateManagedWidget ("loadGroup", xfwfGroupWidgetClass,
			     x_info.optShell.optBox.w,
			     XtNlabel, "Load Options",
			     XtNselectionStyle, XfwfNoSelection,
			     NULL);

  x_info.optShell.optBox.queueGroup.w =
    XtVaCreateManagedWidget ("queueGroup", xfwfGroupWidgetClass,
			     x_info.optShell.optBox.w,
			     XtNlabel, "Queue Options",
			     XtNselectionStyle, XfwfNoSelection,
			     NULL);

  x_info.optShell.optBox.otherGroup.w =
    XtVaCreateManagedWidget ("otherGroup", xfwfGroupWidgetClass,
			     x_info.optShell.optBox.w,
			     XtNlabel, "",
			     XtNselectionStyle, XfwfNoSelection,
			     NULL);

  x_info.optShell.optBox.queueGroup.removeToggle =
    XtVaCreateManagedWidget ("removeToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.queueGroup.w,
			     XtNlabel, "Unqueue After Play",
			     NULL);

  x_info.optShell.optBox.queueGroup.randomToggle =
    XtVaCreateManagedWidget ("randomToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.queueGroup.w,
			     XtNlabel, "Random Order",
			     NULL);

  x_info.optShell.optBox.playGroup.loopBreakToggle =
    XtVaCreateManagedWidget ("loopBreakToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.playGroup.w,
			     XtNlabel, "Break Infinite Loops",
			     NULL);

  x_info.optShell.optBox.playGroup.speed0Toggle =
    XtVaCreateManagedWidget ("speed0Toggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.playGroup.w,
			     XtNlabel, "Ignore Speed0 Commands",
			     NULL);

  x_info.optShell.optBox.queueGroup.highlightToggle =
    XtVaCreateManagedWidget ("highlightToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.queueGroup.w,
			     XtNlabel, "Highlight Current",
			     NULL);

  x_info.optShell.optBox.loadGroup.fiftyhzToggle =
    XtVaCreateManagedWidget ("fiftyhzToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.loadGroup.w,
			     XtNlabel, "50 Hz Clock Freq",
			     NULL);

  x_info.optShell.optBox.loadGroup.palToggle =
    XtVaCreateManagedWidget ("palToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.loadGroup.w,
			     XtNlabel, "PAL Sample Timing",
			     NULL);

  x_info.optShell.optBox.loadGroup.bpmToggle =
    XtVaCreateManagedWidget ("bpmToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.loadGroup.w,
			     XtNlabel, "Disable BPM Tempos",
			     NULL);

  x_info.optShell.optBox.loadGroup.extendedToggle =
    XtVaCreateManagedWidget ("extendedToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.loadGroup.w,
			     XtNlabel, "Extended Octaves",
			     NULL);

  x_info.optShell.optBox.queueGroup.absoluteToggle =
    XtVaCreateManagedWidget ("absoluteToggle", xfwfToggleWidgetClass,
			     x_info.optShell.optBox.queueGroup.w,
			     XtNlabel, "Absolute Pathnames",
			     NULL);

  XtAddCallback (x_info.optShell.optBox.queueGroup.absoluteToggle,
		 XtNonCallback, callback_opt_full_on, (XtPointer) 0);
  XtAddCallback (x_info.optShell.optBox.queueGroup.absoluteToggle,
		 XtNoffCallback, callback_opt_full_off, (XtPointer) 0);

  x_info.optShell.optBox.otherGroup.closeButton =
    XtVaCreateManagedWidget ("closeButton", xfwfButtonWidgetClass,
			     x_info.optShell.optBox.otherGroup.w,
			     XtNlabel, "Close",
			     NULL);

  XtAddCallback (x_info.optShell.optBox.otherGroup.closeButton, XtNactivate,
		 callback_opt, (XtPointer) 0);
}

#endif
