
/* Copyright (C) 1995 by Andrew Robinson */
/*
*	gmod.c	- Module player for GUS and Linux.
*		(C) Hannu Savolainen, 1993
*
*	NOTE!	This program doesn't try to be a complete module player.
*		It's just a too I used while developing the driver. In
*		addition it can be used as an example on programming
*		the VoxWare Sound Driver with GUS.
*/

/*
* Many modifications have been done by Andrew J. Robinson.
* Refer to the ChangeLog for details.
*/


#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#include <sys/ultrasound.h>
#include <stdio.h>
#include <string.h>

#include <time.h>		/* for randomize */
#include <stdlib.h>		/* for randomize */

#ifdef USE_NCURSES
#include <ncurses.h>
#endif

#ifdef USE_X
#include <limits.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>
#include <Xfwf/Alert.h>
#include <Xfwf/Toggle.h>
#include "xdefines.h"
#include "xstructs.h"
#include "xprotos.h"
#include "fallback.h"
#endif

#include "defines.h"
#include "structs.h"
#include "tables.h"
#include "protos.h"

SEQ_DEFINEBUF (2048);

int pattern_len[MAX_POSITION];
int pattern_tempo[MAX_POSITION];
pattern *pattern_table[MAX_PATTERN * MAX_TRACK];

struct voice_info voices[MAX_TRACK];

int tune[MAX_POSITION];
short voice_table[MAX_POSITION][MAX_TRACK];
double tick_duration;

int seqfd, mixerfd;
unsigned char sample_ok[MAX_SAMPLES];
struct sample_info *samples = NULL;
int tmp, gus_dev;
double this_time, next_time;
int ticks_per_division;

unsigned char stop_flag = 0;
unsigned char dump_enabled = 1;
unsigned char background = 0;
int actual_pos = 0;
int position_change = 0;
int driver_version;

#ifdef USE_X
struct x_struct x_info;
int callback_arg;
int current_mod;
String empty_list[] = { "" };
#endif

void read_rc (FILE *, char *, struct options_info *);
unsigned int proc_input (void);
void set_signals (void);
int get_driver_version(void);

int
main (int argc, char *argv[])
{
  static char ident[] = IDENT;
  int i, n, j, name_start, num_files, rand_swap;
  int exit_code = ERR_NOERROR;
  struct synth_info info;
  struct song_info song_char;
#ifdef USE_X
  struct options_info options =
  {255, 0, 1, 1, 0, 0, 0, 255, 0, 0, 100, 0};
#else
  struct options_info options =
  {255, 0, 0, 1, 1, 0, 0, 0, 255, 0, 0, 100, 0};
#endif
  struct options_info saved_opt;
#ifndef USE_X
  char mixer_name[13];
  int mix_devmask;
#endif
  char *tmp_argv, *rc_filename;
  FILE *rc_fp = NULL;
  int start_pos = 0;
  int load_rc = 0;
#ifdef USE_X
  Boolean toggle_stat;
#endif

  song_char.comment = calloc (1, 1);

#ifdef USE_X
  for (i = 0; i < 256; i++)
    x_info.sampleStrings[i] = NULL;

  x_info.trackStrings = NULL;
  x_info.nrTrackStrings = 0;

  x_info.topShell.w = XtVaAppInitialize (&x_info.app_context, "Xgmod", NULL, 0,
				   &argc, argv, fallback, XtNtitle, HEADING,
					 XtNiconName, "Xgmod", NULL);
#endif

  name_start = parse_args (argc, argv, &options);

#ifdef USE_X
  create_widgets ();
#endif

#ifndef USE_X
  printf (HEADING);
  printf ("Original source (C) Hannu Savolainen, 1993\n");
  printf ("Major modifications by Andrew J. Robinson and Robert Sanders\n\n");

  if (name_start == argc)
    {
      printf ("\nUsage: %s [options] modfile . . .\n", argv[0]);
      printf ("Use %s -h for help.\n\n", argv[0]);
      exit (ERR_BADARGS);
    }
#endif

  if ((driver_version = get_driver_version()) >= 3)
    i = O_RDWR | O_NONBLOCK;
  else
    i = O_RDWR;

  if ((seqfd = open ("/dev/sequencer", i, 0)) == -1)
    {
#ifdef USE_X
      XfwfDialog ("seqError", x_info.topShell.w, "FATAL", "Unable to open /dev/sequencer", NULL);
#else
      perror ("/dev/sequencer");
#endif
      exit (ERR_SEQUENCER);
    }

  if (ioctl (seqfd, SNDCTL_SEQ_NRSYNTHS, &n) == -1)
    {
#ifdef USE_X
      XfwfDialog ("synthError", x_info.topShell.w, "FATAL", "Unable to determine\nnumber of synths.", NULL);
#else
      perror ("/dev/sequencer");
#endif
      exit (ERR_SEQUENCER);
    }

  for (i = 0; i < n; i++)
    {
      info.device = i;

      if (ioctl (seqfd, SNDCTL_SYNTH_INFO, &info) == -1)
	{
#ifdef USE_X
	  XfwfDialog ("infoError", x_info.topShell.w, "FATAL", "Unable to determine\nsynth information.", NULL);
#else
	  perror ("/dev/sequencer");
#endif
	  exit (ERR_SEQUENCER);
	}

      if (info.synth_type == SYNTH_TYPE_SAMPLE
	  && info.synth_subtype == SAMPLE_TYPE_GUS)
	gus_dev = i;
    }

  if (gus_dev == -1)
    {
#ifdef USE_X
      XfwfDialog ("gusError", x_info.topShell.w, "FATAL", "Gravis Ultrasound not detected", NULL);
#else
      fprintf (stderr, "Gravis Ultrasound not detected\n");
#endif
      exit (ERR_NOGUS);
    }

#ifndef USE_X
  if (options.mixer == 255)
    sprintf (mixer_name, "%s", "/dev/mixer");
  else
    sprintf (mixer_name, "%s%u", "/dev/mixer", options.mixer);

  if ((mixerfd = open (mixer_name, O_RDWR, 0)) == -1)
    printf ("Mixer (%s) not available.\n", mixer_name);
  else
    {
      ioctl (mixerfd, SOUND_MIXER_READ_DEVMASK, &mix_devmask);
      if (!(mix_devmask & SOUND_MASK_SYNTH))
	{
	  printf ("This mixer (%s) does not support volume control.\n", mixer_name);
	  close (mixerfd);
	  mixerfd = -1;
	}
    }
#endif

  if ((tmp_argv = getenv ("HOME")) != NULL)
    {
      rc_filename = (char *) malloc (strlen (tmp_argv) + 8);
      strcpy (rc_filename, tmp_argv);
      strcat (rc_filename, USER_RC_NAME);
      rc_fp = fopen (rc_filename, "r");
      free (rc_filename);
    }

  if (rc_fp == NULL)
    rc_fp = fopen (RC_NAME, "r");

  /*  stop_all_channels (MY_FALSE); */
#ifndef USE_X
  if (!background)
    {
#ifdef USE_NCURSES
      initscr ();
      cbreak ();
      noecho ();
      timeout (0);
      keypad (stdscr, TRUE);
#else
      terminal_set (TERMINAL_RAW);
#endif
    }
#endif /* USE_X */

  num_files = argc - name_start;
  srand (time (NULL));

  if (options.randomize)
    {
      for (i = name_start; i < argc; i++)
	{
	  rand_swap = name_start + (rand () % num_files);
	  tmp_argv = argv[i];
	  argv[i] = argv[rand_swap];
	  argv[rand_swap] = tmp_argv;
	}
    }

#ifdef USE_X
  x_info.nrFileStrings = argc - name_start;

  if (x_info.nrFileStrings > 0)
    {
      x_info.fileStrings = malloc (sizeof (String) * x_info.nrFileStrings);

      for (i = name_start; i < argc; i++)
	x_info.fileStrings[i - name_start] = strdup (argv[i]);

      XawListChange (x_info.infoShell.infoPane.fileView.fileList,
		     x_info.fileStrings, x_info.nrFileStrings, 0, True);
    }
  else
    {
      x_info.fileStrings = NULL;
      XawListChange (x_info.infoShell.infoPane.fileView.fileList,
		     empty_list, 1, 0, True);
      XtVaSetValues (x_info.infoShell.infoPane.fileView.fileList,
		     XtNsensitive, False, NULL);
    }
#endif

  /* set the path and ifs to something safe before loading modules */

  putenv (PATH);
  putenv (IFS);

  saved_opt = options;

#ifdef USE_X
  set_inputs (INPUTS_READ, INPUTS_ADD);
  set_inputs (INPUTS_WRITE, INPUTS_ADD);
#else
  set_signals ();
#endif

  stop_all_channels (MY_FALSE);

#ifdef USE_X
  current_mod = -1;
  do
    {
      if ((current_mod < 0) || (current_mod >= x_info.nrFileStrings))
	{
	  check_buttons ();

	  while ((stop_flag != STOP_EXIT) && ((current_mod < 0) || (current_mod >= x_info.nrFileStrings)))
	    {
	      stop_flag = 0;
	      XtAppProcessEvent (x_info.app_context, XtIMXEvent | XtIMTimer | XtIMSignal);
	    }

	  if (stop_flag == STOP_EXIT)
	    continue;

	  dump_enabled = 1;
	  stop_flag = 0;
	}
      check_buttons ();
#else
  for (i = name_start; i < argc; i++)
    {
#endif
#ifdef USE_X
      XtVaGetValues (x_info.optShell.optBox.queueGroup.highlightToggle,
		     XtNon, &toggle_stat, NULL);

      if (toggle_stat == True)
	XawListHighlight (x_info.infoShell.infoPane.fileView.fileList, current_mod);
#endif
      if (stop_flag != STOP_FORWBACK)
	{
	  for (j = 0; j < MAX_PATTERN; j++)
	    pattern_table[j] = NULL;

#ifndef USE_X
	  fprintf (stderr, "\n");
#endif
	  options = saved_opt;

#ifdef USE_X
	  XtVaGetValues (x_info.optShell.optBox.loadGroup.fiftyhzToggle,
			 XtNon, &toggle_stat, NULL);

	  if (toggle_stat == True)
	    options.use_50hz = 1;
	  else
	    options.use_50hz = 0;

	  XtVaGetValues (x_info.optShell.optBox.loadGroup.palToggle,
			 XtNon, &toggle_stat, NULL);

	  if (toggle_stat == True)
	    options.pal = 1;
	  else
	    options.pal = 0;

	  XtVaGetValues (x_info.optShell.optBox.loadGroup.bpmToggle,
			 XtNon, &toggle_stat, NULL);

	  if (toggle_stat == True)
	    options.bpm_tempos = 0;
	  else
	    options.bpm_tempos = 1;

	  XtVaGetValues (x_info.optShell.optBox.loadGroup.extendedToggle,
			 XtNon, &toggle_stat, NULL);

	  if (toggle_stat == True)
	    options.extend_oct = 1;
	  else
	    options.extend_oct = 0;
#endif

	  if (rc_fp != NULL)
	    {
#ifdef USE_X
	      read_rc (rc_fp, x_info.fileStrings[current_mod], &options);
#else
	      read_rc (rc_fp, argv[i], &options);
#endif
	    }
#ifdef USE_X
	  load_rc = load_module (x_info.fileStrings[current_mod], &song_char, options);
#else
	  load_rc = load_module (argv[i], &song_char, options);
#endif
	}

      stop_flag = 0;

      if (load_rc)
	{
	  actual_pos = 0;
	  position_change = 0;

	  ioctl (seqfd, SNDCTL_SEQ_SYNC, 0);

	  if (song_char.nr_channels < 14)
	    {
	      GUS_NUMVOICES (gus_dev, 14);
	    }
	  else
	    {
	      GUS_NUMVOICES (gus_dev, song_char.nr_channels);
	    }

	  /* set the proper volume method */

#ifdef LINEAR_VOLUME
	  SEQ_VOLUME_MODE (gus_dev, VOL_METHOD_LINEAR);
#else
	  SEQ_VOLUME_MODE (gus_dev, VOL_METHOD_ADAGIO);
#endif

	  SEQ_DUMPBUF ();
	  ioctl (seqfd, SNDCTL_SEQ_SYNC, 0);

	  /*
  timer_set (TIMER_ON);
  */
#ifdef USE_X
	  flush_xbuffer ();
	  start_pos = play_module (start_pos, &song_char, options);
#else
	  start_pos = play_module (start_pos, &song_char, options);
#endif
	  /*
  timer_set (TIMER_OFF);
  */

#ifndef USE_X
	  if (stop_flag == STOP_EXIT)
	    {
	      i = argc - 1;
	    }
	  else if (stop_flag == STOP_PREV)
	    {
	      i -= 2;
	      if (i < (name_start - 1))
		i = name_start - 1;
	    }
#endif

	  if (stop_flag == STOP_FORWBACK)
	    {
#ifndef USE_X
	      i -= 1;
#endif
	      start_pos = actual_pos + position_change;
	      if (start_pos < 0)
		start_pos = 0;
	    }
	  else
	    {
	      start_pos = 0;
#ifdef USE_X
	      XtVaSetValues (x_info.topShell.w, XtNtitle, HEADING, NULL);
	      XtVaSetValues (x_info.trackShell.w, XtNtitle, "Xgmod Tracker", NULL);
	      XawListChange (x_info.trackShell.trackForm.trackView.trackBoard.trackList,
			     NULL, 0, 0, True);
#endif
	    }
	}
      else
	exit_code = ERR_BADLOAD;

#ifdef USE_X
      if (stop_flag == 0)
	{
	  if (remove_mod (current_mod) != True)
	    current_mod++;

	  pick_random ();
	}
    }
  while (stop_flag != STOP_EXIT);
#else
    }
#endif
  SEQ_DUMPBUF ();

  close (seqfd);
  fclose (rc_fp);

#ifndef USE_X
  if (!background)
    {
#ifdef USE_NCURSES
      endwin ();
#else
      terminal_set (TERMINAL_RESTORE);
#endif
    }
#else /* USE_X */
  XtDestroyWidget (x_info.topShell.w);
  XtDestroyApplicationContext (x_info.app_context);
#endif

  exit (exit_code);
}
