#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef USE_X
#include <X11/Intrinsic.h>
#include <Xfwf/Alert.h>

#include "xstructs.h"
#include "xglobals.h"
#endif

int
get_driver_version(void)
{
  FILE *fp;
  char buffer[80];
  char *ptr;
  int version = 0;

  if ((fp = fopen("/dev/sndstat", "r")) != NULL)
    {
      fgets(buffer, 80, fp);
      ptr = buffer;

      while ((*ptr != ':') && (*ptr != '\0'))
	ptr++;

      if (*ptr != '\0')
	{
	  ptr++;

	  while ((*ptr != '\0') && (!isdigit(*ptr)))
	    ptr++;

	  if (*ptr != '\0')
	    version = atoi(ptr);
	}
	
      fclose(fp);
    }
	
  if (version == 0)
    {
#ifdef USE_X
      XfwfDialog("versionWarning", x_info.topShell.w, "WARNING", "Unable to determine driver version.\nPlease check that /dev/sndstat is readable.\n\nVersion 2 will be used as the default.", NULL);
#else
      fprintf(stderr, "Unable to determine sequencer version.\nPlease check that /dev/sndstat is readable.\nVersion 2 will be used as the default.\n");
#endif
      version = 2;
    }
  return (version);
}
