/* 
 * DialP.h - Private definitions for Dial widget
 *
 * (c) 1995 by Martin Denn <mdenn@unix-ag.uni-kl.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _DialP_h
#define _DialP_h

/*
 * This include not needed unless the .c file includes IntrinsicP.h
 * after this file.   Anyway, it doesn't hurt.
 */
#include <X11/CoreP.h>

/*
 * This one is always needed!
 */
#include "Dial.h"

/* New fields for the Dial widget class record */

/* There is no need for new fields, but the compiler needs something... */
typedef struct {
	int make_compiler_happy;	/* keep compiler happy */
} DialClassPart;

/* Full class record declaration */
typedef struct _DialClassRec {
    CoreClassPart	core_class;
    DialClassPart	dial_class;
} DialClassRec;

extern DialClassRec dialClassRec;

/* New fields for the Dial widget record */
typedef struct {
    /* resources */
    Pixel	dial_border_color;
    Pixel	dial_color;
    Pixel	dial_back_color;
    Pixel	dial_point_color;
    Pixel	dial_point_border_color;
    Pixel	label_color;
    int		cur_value;
    XtCallbackList callback;	/* application installed callback function(s) */
    XFontStruct	*font;
    char	*label;
    /* private state */
    GC		gc;		/* the used gc */
    Pixmap	pix;            /* pixmap buffer*/
} DialPart;

/*
 * Full instance record declaration
 */
typedef struct _DialRec {
    CorePart		core;
    DialPart		dial;
} DialRec;

#endif /* _DialP_h */
