/*
 * Dial Widget public include file
 *
 * (c) 1995 by Martin Denn <mdenn@unix-ag.uni-kl.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _Dial_h
#define _Dial_h

/*
 * This include not needed unless the application includes Intrinsic.h
 * after this file.   Anyway, it doesn't hurt.
 */
#include <X11/Core.h>

/* Resources:
 * Name		     Class		RepType		Default Value
 * ----		     -----		-------		-------------
 * (from RectObj)
 * ancestorSensitive
 * x		    Position		Int		0
 * y		    Position		Int		0
 * width	    Dimension		Dimension	0
 * height	    Dimension		Dimension	0
 * borderWidth	    BorderWidth		Int
 * sensitive	    Sensitive
 *
 * (from WindowObj)
 * screen	    Screen		Pointer		XtCopyScreen
 * depth	    Depth		Int		XtCopyFromParent
 * colormap	    Colormap	        Pointer	        XtCopyFromParent
 * background	    Background		Pixel		White
 * backgroundPixmap    Pixmap		Pixmap		XtUnspecifiedPixmap
 * borderColor	    BorderColor		Pixel		Black
 * borderPixmap	    BorderPixmap	Pixmap		XtUnspecifiedPixmap
 * mappedWhenManaged   MappedWhenManaged	Boolean		True
 * translations
 * accelerators
 *
 * (from Core)
 * none
 *
 * (from Dial)
 * dialBorderColor  DialBorderColor	Pixel		Black	
 * dialColor	    DialColor		Pixel		Black 
 * dialBackColor    DialBackColor	Pixel		White
 * dialPointColor   DialPointColor	Pixel		White
 * dialPointBorderColor DialPointBorderColor 	Pixel		Black
 * labelColor	    LabelColor		Pixel		Black
 * curValue	    CurValue		Int		0
 * callback	    Callback		Callback	NULL
 * label	    Label		String		NULL
 * font		    Font		XFontStruct*	XtDefaultFont
 */

 
#define XtNdialBorderColor "dialBorderColor"
#define XtNdialColor "dialColor"
#define XtNdialBackColor "dialBackColor"
#define XtNdialPointColor "dialPointColor"
#define XtNdialPointBorderColor "dialPointBorderColor"
#define XtNlabelColor "labelColor"
#define XtNcurValue "curValue"

#define XtCDialBorderColor "DialBorderColor"
#define XtCDialColor "DialColor"
#define XtCDialBackColor "DialBackColor"
#define XtCDialPointColor "DialPointColor"
#define XtCDialPointBorderColor "DialPointBorderColor"
#define XtCLabelColor "LabelColor"
#define XtCCurValue "CurValue"

/* Data type returned by XtNCallback */
typedef struct 
{
    int value;
} DialInfo; 



/* Class record constants */

extern WidgetClass dialWidgetClass;

typedef struct _DialClassRec *DialWidgetClass;
typedef struct _DialRec      *DialWidget;

#endif /* _Dial_h */
/* DON'T ADD STUFF AFTER THIS #endif */
