#!/bin/bash
ECHO=`which echo`
$ECHO
$ECHO "XMix v2.1 installation script"
$ECHO
$ECHO "By GrimJack, dcarmich@mcs.com"
$ECHO
$ECHO "Checking to see if you are root..."
WHOAMI=`which whoami`
WHOFLAG=`$WHOAMI | grep -c "root"`
if [ "$WHOFLAG" = "1" ]; then
echo "You are running as root. Continuing with installation."
XRDB=`which xrdb`
CP=`which cp`
CHMOD=`which chmod`
LDCONFIG=`which ldconfig`
APPDEFDIR="/usr/X11R6/lib/X11/app-defaults"
if [ -f /usr/X11R6/lib/libX11.a ]; then
$ECHO "X11R6 found. Checking for Xaw3d libraries."
if [ -f /usr/X11R6/lib/libXaw3d.so.6 ]; then
$ECHO "You do seem to have the Xaw3d library installed. Installing dynamically linked version into /usr/X11R6/bin."
$CP xmix.dynamic /usr/X11R6/bin/xmix
$CHMOD a+x /usr/X11R6/bin/xmix
$CP Xmix.Xaw3D-appdefaults $APPDEFDIR/XMix
$CP xmix.1 /usr/man/man1/xmix.1
$ECHO "Refreshing X resource database."
$XRDB $APPDEFDIR/XMix
$ECHO "Updating shared library links."
$LDCONFIG
$ECHO "Installation done."
exit 0
else
$ECHO "You do not seem to have the Xaw3d library installed. Installing statically linked version."
$CP xmix.static /usr/X11R6/bin/xmix
$CHMOD a+x /usr/X11R6/bin/xmix
$CP Xmix.Xaw3D-appdefaults $APPDEFDIR/XMix
$CP xmix.1 /usr/man/man1/xmix.1
$ECHO "Refreshing X resource database."
$XRDB $APPDEFDIR/XMix
$ECHO "Installation done."
exit 0
fi
else
$ECHO "X11R6 not found. Installation aborted!"
exit 1
fi
else
$ECHO "You are not root. Installation aborted!"
exit 1
fi


