// song.h,v 2.1 1995/06/19 19:04:47 andreas Exp

/*
**  jazz - a midi sequencer for Linux
**
**  Copyright (C) 1994 Andreas Voss (andreas@avix.rhein-neckar.de)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef song_h
#define song_h

#ifndef track_h
#include "track.h"
#endif

// ************************************************************************
// Song
// ************************************************************************

class tSong;

class tBarInfo
{
    tEventIterator Iterator;
    tEvent *e;
    int TicksPerQuarter;

  public:
    int   BarNr;
    long  Clock;
    int   TicksPerBar;
    int   CountsPerBar;

    tBarInfo(tSong *Song);
    void SetBar(int Bar = 0);
    void SetClock(long Clock = 0);
    void Next();
};


#define MaxTracks 100


class tSong
{
  friend class tBarInfo;

  public:

    int nTracks;
    int TicksPerQuarter;

    tTrack *Tracks[MaxTracks];
    void NewUndoBuffer();
    void Undo();

    tSong();
    virtual ~tSong();

    void Clear();
    void Read(tReadBase &io, char *fname = 0);
    void Write(tWriteBase &io, char *fname = 0);

    tTrack *GetTrack(int Nr);
    long GetLastClock();

    void Clock2String(long Clock, char *buf);
    long String2Clock(char *buf);

    // merge Events from all Tracks into Destin
    void MergeTracks(long FrClock, long ToClock, tEventArray *Destin, long DeltaClock = 0);
    void SetTicksPerQuarter(int NewTicks);
    int  SetMeterChange(int BarNr, int Numerator, int Denomiator); //  0 = ok
};


#endif
