/* Code necessary for modload to do its thing */
/* Per Sigmond <Per.Sigmond@hiagder.no> */

#include <sys/types.h>
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sundev/mbvar.h>
#include <sun/autoconf.h>
#include <sun/vddrv.h>
#include "mpureg.h"


/* Have to know about the existance of these functions in order to init the structs */
extern mpuopen(), nulldev(), mpuread(), mpuwrite(), mpuselect(), mpuclose(), nodev();

/* This struct is defined in the driver-code itself */
extern struct mb_driver mpudriver;

/* This is where the mapping between major device number and device driver functions are done */
struct cdevsw mpudev = {
	mpuopen, 	mpuclose, 	mpuread, 	mpuwrite,
	nodev,   	nodev, 		mpuselect,	0,
	0
};

/* This struct has to be here, but is really initialized by modload (it seems) */
/* Except for &mpudriver that is... */
struct mb_device mpudevice[] = {
	&mpudriver,   0,   0,   0,     (caddr_t) 0x00000000, 0,   0, 0x0, 0, 0x0, 0
};

/* This struct sort of tells xxxinit() what it should initialize */
struct vdldrv vd = {
	VDMAGIC_DRV, 	/* Type of module */
	"mpu",		/* Name of module */
	NULL, 		/* No controller */
	&mpudriver,	/* Address of the driver struct */
	mpudevice,	/* Address of the mb_device struct array */
	0,		/* Number of controllers */
	1,		/* Number of devices */
	NULL,		/* Address of bdevsw entry (this is not a block device) */
	&mpudev,	/* Address of cdevsw entry (but it is a character device) */
	0,		/* Block device number */
	0,		/* Character device number (0 lets system choose) */
};

/* Probably used by modload to initialize the whole thing */
/* By some reason the name must be xxxinit() */
xxxinit(function_code, vdp, vdi, vds )
unsigned int function_code;
struct vddrv *vdp;
addr_t vdi;
struct vdstat *vds;
{
	switch (function_code) {
		case VDLOAD:
			vdp->vdd_vdtab = (struct vdlinkage *) &vd;
			/* My device card is so slow that the kernel times out on the
			   IO_RDY pin on the AT-bus when doing outb() and inb(). Have 
			   to clear the ENABLE_BUS_TIMEOUT bit in the kernel SYSCTRL
			   register (or else the kernel panics).
			*/
			DISABLE_BUS_TIMEOUT;
			return(0);
		case VDUNLOAD:
			return( unload(vdp, vdi) );
		case VDSTAT:
			return(0);
		default:
			return( EIO );
	}
}

static unload(vdp, vdi)
struct vddrv *vdp;
struct vdioctl_unload *vdi;
{
	/* Should we bother enabling it again ??? */
	/* ENABLE_BUS_TIMEOUT; */
	return(0);
}
