/* midinetd.c using TCP protocol - Written by Per Sigmond, HiA			*/

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <errno.h>
#include <fcntl.h>
#include <tcp.h>
#include "midinetd.h"
#include "mpu.h"

#define MAXTRIES 1000

#define CMD (2<<6)
#define DAT (1<<6)
#define RES (3<<6)

#define BUFFERSIZE 1024

#define CLOCK_TO_HOST 0xfd
#define START_PLAY_COMMAND 0xfa
#define STOP_PLAY_COMMAND 0xfb
#define START_OF_RECORD_BUFFER 0xfb

int midinetd(tcp_Socket *s)
{
unsigned char sockbuf[BUFFERSIZE];
unsigned char *sockbuf_ptr;
int sockbytes, sockbytes_read, sockbytes_to_write;
unsigned char filebuf[BUFFERSIZE];
unsigned char *recbuf = NULL;
int bytes_in_recbuf = 0;
int size_of_recbuf = 0;
int recbuf_bytes_sent, bytes_sent_now;
int filebytes;
char clock_to_host_byte = CLOCK_TO_HOST;
unsigned char start_play_command = START_PLAY_COMMAND;
int start_play_command_received = 0;
unsigned char stop_play_command = STOP_PLAY_COMMAND;
int stop_play_command_received = 0;
unsigned char start_marker = START_OF_RECORD_BUFFER;
long longsend;
byte *longptr;
int status;

int i, j;
int k;
unsigned char ch;

mpu_init();

sockbytes = 0;

/* loop */
while ( tcp_tick( s ) ) {
	/* File ready ? */
	filebytes = read_mpu( filebuf, BUFFERSIZE );

	/* Write to recbuffer and send clock-to-host to socket */
	if (filebytes > 0) {
		for (k = 0; k < filebytes; k++) {
			ch = filebuf[k];
			if (ch == 0xff) continue; /* I sometimes get these 0xff bytes, 
			                             don't know why but they are of no use */
			/* clock-to-host received ? */
			if (ch == 0xfd) {
				/* Send clock-to-host to jazz */
				for (i = 0; i < MAXTRIES; i++) {
					sock_flushnext( s );
					j = sock_write( s, (byte*) &clock_to_host_byte, 1 );
					if (j == 1) break;
				}
				if (i >= MAXTRIES) {
					perror("write socket (1)");
					return(-1);
				}
			}
			else {
				/* record byte received; store in record buffer */
				if (bytes_in_recbuf >= size_of_recbuf) {
					recbuf = (unsigned char*) realloc( recbuf, size_of_recbuf + BUFFERSIZE );
					if (!recbuf) return(-1);
					size_of_recbuf = size_of_recbuf + BUFFERSIZE;
				}
				recbuf[bytes_in_recbuf++] = ch;
			}
		}
	}

	if (!tcp_tick(s)) return(0);

	/* Socket ready ? */
        if (sock_dataready( s )) {
           	sock_wait_input( s, sock_delay, NULL, &status );
           	sockbytes_read = sock_fastread( s, sockbuf + sockbytes, BUFFERSIZE - sockbytes );
		sockbytes = sockbytes + sockbytes_read;
	   	if (sockbytes == 0) break;

		/* Did jazz request start playing ? */
		sockbuf_ptr = memchr( sockbuf, start_play_command, sockbytes );
		if ( sockbuf_ptr ) { /* Yes */
#ifdef DEBUG
cprintf("StopPlay %d %d\r\n", bytes_in_recbuf, size_of_recbuf);
#endif
			/* Take the command byte away and adjust the sockbuf data */
			while (sockbuf_ptr < &sockbuf[sockbytes]) {
				*sockbuf_ptr = *(sockbuf_ptr + 1);
				sockbuf_ptr++;
			}
			sockbytes--;
			start_play_command_received = 1;
		}
		else {
			start_play_command_received = 0;
		}

		if (!tcp_tick(s)) return(0);

		/* Did jazz request stop playing ? */
		sockbuf_ptr = memchr( sockbuf, stop_play_command, sockbytes );
		if ( sockbuf_ptr ) { /* Yes */
#ifdef DEBUG
cprintf("StopPlay %d %d\r\n", bytes_in_recbuf, size_of_recbuf);
#endif
			/* Take the command byte away and adjust the sockbuf data */
			while (sockbuf_ptr < &sockbuf[sockbytes]) {
				*sockbuf_ptr = *(sockbuf_ptr + 1);
				sockbuf_ptr++;
			}
			sockbytes--;
			recbuf_bytes_sent = 0;
			stop_play_command_received = 1;
		}
		else {
			stop_play_command_received = 0;
		}

		if (!tcp_tick(s)) return(0);

		/* Write socket data to file */
		if (sockbytes > 0) {
                        /* Check for incomplete commands */
                        /* (TCP does not guarantee block boundaries) */
                        {
                                char *ptr, *beg, *end, *cmd;

                                /* Set "ptr" at beginning, set "end" at
                                   first "unused" byte:
                                 */
                                beg = sockbuf; end = &sockbuf[sockbytes];
                                ptr = beg; cmd = beg;
                                while (ptr < end) {
                                        char n;
                                        cmd = ptr;
                                        n = *ptr & 0x3f;
                                        ptr = ptr + n + 1;
                                }
                                /* "ptr" will now point one byte after last
                                   command. If complete commands, this will be
                                   same as "end".
                                   "cmd" points at beginning of last command.
                                */
                                if (ptr > end) {
                                        /* Last command incomplete.
                                           Remember how many bytes.
                                        */
                                        sockbytes_to_write = cmd - beg;
fprintf( stderr, "Incomplete: %d\n", sockbytes - sockbytes_to_write );
                                }
                                else {
                                        /* Complete commands. Write all bytes */
                                        sockbytes_to_write = sockbytes;
                                }

                        }

			if (!tcp_tick(s)) return(0);

			j = 0;
#ifdef DEBUG
cprintf("F: ");
for (k=0; k<sockbytes; k++) cprintf("%02x ", (unsigned char) sockbuf[k] );
cprintf("\r\n");
#endif
			for (i = 0; i < MAXTRIES; i++) {
				k = write_mpu(sockbuf + j, sockbytes_to_write - j);
				if (k > 0) j = j + k;
				if (j >= sockbytes_to_write) break;
			}
			if (i >= MAXTRIES) {
				perror("write file (1)");
				return(-1);
			}
                        /* Move remaining bytes to beginning of buffer */
                        for (i = 0, j = sockbytes_to_write; j < sockbytes; i++, j++) {
                                sockbuf[i] = sockbuf[j];
                        }
                        /* Remember how many to write next time */
                        sockbytes = i;
		}

		if (!tcp_tick(s)) return(0);

		if ( start_play_command_received ) {
#ifdef DEBUG
cprintf("StartPlay\r\n");
#endif
			/* Start play command received */
			if (recbuf) free( recbuf );
			recbuf = NULL;
			bytes_in_recbuf = 0;
			recbuf = (unsigned char*) malloc( BUFFERSIZE );
			if (!recbuf) return( -1 );
			size_of_recbuf = BUFFERSIZE;
		}

		if (!tcp_tick(s)) return(0);

		/* Did we receive request for sending record buffer data? */
		if ( stop_play_command_received ) {
#ifdef DEBUG
cprintf("S: ");
for (k=0; k<bytes_in_recbuf; k++) cprintf("%02x ", (unsigned char) recbuf[k] );
cprintf("\r\n");
cprintf("Sending recbuf...\r\n");
#endif
			/* Yes, send start marker first (0xf9) */
			sock_flushnext( s );
			while( sock_write( s, &start_marker, 1 ) < 1 )
			;
			/* Send number of bytes in record buffer */
#ifdef DEBUG
cprintf("Bytes to be sent %d\r\n", bytes_in_recbuf );
#endif
			longsend = htonl( (long) bytes_in_recbuf );
			sock_flushnext( s );
			if (sock_write( s, (byte*) &longsend, sizeof(long)) != sizeof(long) )
				return( -1 );

			/* Send contents of record buffer */
			recbuf_bytes_sent = 0;
			while (recbuf_bytes_sent < bytes_in_recbuf) {
				if ( (bytes_in_recbuf - recbuf_bytes_sent) >= BUFFERSIZE)
					k = BUFFERSIZE;
				else
					k = bytes_in_recbuf - recbuf_bytes_sent;
				sock_flushnext( s );
				bytes_sent_now = sock_write(s, recbuf + recbuf_bytes_sent, k );
				if (bytes_sent_now <= 0) {
					perror("write socket (2)");
					return( -1 );
				}
				recbuf_bytes_sent = recbuf_bytes_sent + bytes_sent_now;
			}
#ifdef DEBUG
cprintf("Recbuf sent: %d bytes\r\n", recbuf_bytes_sent);
#endif
		}
	}


} /* end while */
return(0);
sock_err:
	return(-1);
} /* end main */
