/* $Id: k1vis.c,v 1.6 89/05/06 17:13:28 lee Exp $
 * GLIB - a Generic LIBrarian and editor for synths
 *
 * Data Display Routines
 *
 * K1 version adapted from Kesti's D-10 version by Greg Lee
 * $Log:	k1vis.c,v $
 * Revision 1.6  89/05/06  17:13:28  lee
 * rel. to comp.sources.misc
 * 
 */

#include <stdio.h>

extern int Redraw;	/* if non-0, edit screen is completely redrawn. */

char *visnum();

char *
vispnum(v)
{
	return(visnum(v+1));
}

char *
vispan(v)
{
	switch (v) {
	case 0: return("R");
	case 1: return("L+R");
	case 2: return("L");
	}
	return("*");
}

char *
vispoly(v)
{
	switch (v) {
	case 0: return("VR");
	case 1: return("MUT");
	case 2: return("1");
	case 3: return("2");
	case 4: return("3");
	case 5: return("4");
	case 6: return("5");
	case 7: return("6");
	case 8: return("7");
	case 9: return("8");
	}
	return("*");
}

char *
visvelosw(v)
{
	switch (v) {
	case 0: return("ALL");
	case 1: return("SFT");
	case 2: return("LD");
	}
	return("*");
}

char *
vismode(v)
{
	switch (v) {
	case 0: return("KBD");
	case 1: return("MDI");
	case 2: return("MIX");
	}
	return("*");
}

char *
vistwofour(v)
{
	switch (v) {
	case 0: return("2");
	case 1: return("4");
	}
	return("*");
}

char *
vismute(v)
{
	switch (v) {
	case 0: return("ON");
	case 1: return("MUT");
	}
	return("*");
}

char *
vispolym(v)
{
	switch (v) {
	case 0: return("PL1");
	case 1: return("PL2");
	case 2: return("SOL");
	}
	return("*");
}

char *
visvbwh(v)
{
	switch (v) {
	case 0: return("DEP");
	case 1: return("SPD");
	}
	return("*");
}

char *
viscrv(v)
{
	switch (v) {
	case 0: return("1  /");
	case 1: return("2 _--~u_");
	case 2: return("3 _-~u__");
	case 3: return("4 _/~u_");
	case 4: return("5 _|~u_");
	}
	return("*");
}


char *viskeyshift(v)
{
static char viskeyshiftbuf[4];

	if((v >= 0) && (v <= 23)) {
		(void)sprintf(viskeyshiftbuf,"-%d",abs(v - 24));
		return(viskeyshiftbuf);
	} else if(v == 24) {
		(void)sprintf(viskeyshiftbuf,"0");
		return(viskeyshiftbuf);
	} else if((v >= 25) && (v <= 48)) {
		(void)sprintf(viskeyshiftbuf,"+%d", (v - 24));
		return(viskeyshiftbuf);
	} else {
		if (v < 0) return("-*"); else return("+*");
	}
}

char *visfinetune(v)
{
static char visfinetunebuf[4];

	if((v >= 0) && (v <= 49)) {
		(void)sprintf(visfinetunebuf,"-%d",abs(v - 50));
		return(visfinetunebuf);
	} else if(v == 50) {
		(void)sprintf(visfinetunebuf,"0");
		return(visfinetunebuf);
	} else if((v >= 51) && (v <= 100)) {
		(void)sprintf(visfinetunebuf,"+%d",(v - 50));
		return(visfinetunebuf);
	} else {
		return("*");
	}
}

static	char *cpitch_table[] = {
	"C",
	"C#",
	"D",
	"D#",
	"E",
	"F",
	"F#",
	"G",
	"G#",
	"A",
	"A#",
	"B"
};

char *
viscpitch(v)
{
static	char	viscpitchbuf[4];

	if((v >= 0) && (v <= 127)) {
		strcpy(viscpitchbuf, cpitch_table[v % 12]);
		if(strlen(viscpitchbuf) == 1) {
			(void)sprintf(viscpitchbuf+1, "%d", v/12 - 2);
		} else {
			(void)sprintf(viscpitchbuf+2, "%d", v/12 - 2);
		}
		return(viscpitchbuf);
	} else {
	return("*");
	}
}

char *
vislpitch(v)
{
static	char	vislpitchbuf[4];

	if((v >= 0) && (v <= 127)) {
		strcpy(vislpitchbuf, cpitch_table[v % 12]);
		if(strlen(vislpitchbuf) == 1) {
			(void)sprintf(vislpitchbuf+1, "%d", v/12 - 4);
		} else {
			(void)sprintf(vislpitchbuf+2, "%d", v/12 - 4);
		}
		return(vislpitchbuf);
	} else {
	return("*");
	}
}

char *visonoff();

int ky_tk1=0, ky_tk2=0, ky_tk3=0, ky_tk4=0;

char *visonoffk1(v) { ky_tk1 = v; Redraw = 1; return(visonoff(v)); }
char *visonoffk2(v) { ky_tk2 = v; Redraw = 1; return(visonoff(v)); }
char *visonoffk3(v) { ky_tk3 = v; Redraw = 1; return(visonoff(v)); }
char *visonoffk4(v) { ky_tk4 = v; Redraw = 1; return(visonoff(v)); }

char *
viscsfnk1(v) {if (ky_tk1) return(viskeyshift(v-60)); else return(vislpitch(v));}
char *
viscsfnk2(v) {if (ky_tk2) return(viskeyshift(v-60)); else return(vislpitch(v));}
char *
viscsfnk3(v) {if (ky_tk3) return(viskeyshift(v-60)); else return(vislpitch(v));}
char *
viscsfnk4(v) {if (ky_tk4) return(viskeyshift(v-60)); else return(vislpitch(v));}

char *
visam1(v)
{
	switch(v) {
	case 0: return("OFF");
	case 1: return("2>1");
	case 2: return("1>2");
	}
	return("*");
}

char *
visam3(v)
{
	switch(v) {
	case 0: return("OFF");
	case 1: return("4>3");
	case 2: return("3>4");
	}
	return("*");
}


char *visifosh(v)
{
	switch (v) {
	case 0: return("TRI");
	case 1: return("SAW");
	case 2: return("SQR");
	case 3: return("RND");
	}
	return("*");
}

static	char *wave_table[] = {
	"sin 1st",
	"sin 2nd",
	"sin 3rd",
	"sin 4th",
	"sin 5th",
	"sin 6th",
	"sin 7th",
	"sin 8th",
	"sin 9th",
	"sin 10th",
	"sin 11th",
	"sin 12th",
	"sin 16th",
	"saw 1",
	"saw 2",
	"saw 3",
	"saw 4",
	"saw 5",
	"saw 6",
	"saw 7",
	"saw 8",
	"saw 9",
	"saw 10",
	"saw 11",
	"saw 12",
	"saw 13",
	"saw 14",
	"saw 15",
	"saw 16",
	"saw 17",
	"saw 18",
	"saw 19",
	"square 1",
	"square 2",
	"square 3",
	"square 4",
	"square 5",
	"inverse-saw",
	"triangle",
	"random",
	"french horn",
	"    string",
	"    string",
	"string pad",
	"   piano 1",
	" el. grand",
	"e. piano 1",
	"e. piano 2",
	"e. piano 3",
	"     clavi",
	"      vibe",
	" a. guitar",
	" f. guitar",
	" f. guitar",
	"   ac bass",
	"   ac bass",
	"digi bass1",
	" pick bass",
	"digi bass2",
	"round bass",
	"  fretless",
	"  fretless",
	"     flute",
	"  panflute",
	" harmonica",
	"   glocken",
	"      tine",
	"      harp",
	"   marimba",
	"    e. tom",
	"  log drum",
	"jass orgn1",
	" mello pad",
	"synth solo",
	"   synth 2",
	"frnch horn",
	"frnch horn",
	"     brass",
	"     brass",
	"     brass",
	"     brass",
	"   trumpet",
	"   trumpet",
	"    violin",
	"    string",
	"   piano 1",
	"   piano 2",
	"   piano 3",
	"   piano 2",
	"   piano 3",
	"   piano 4",
	"   piano 4",
	" el. grand",
	"e. piano 1",
	"e. piano 2",
	"e. piano 3",
	"     clavi",
	"harpsichord",
	"      vibe",
	" a. guitar",
	" f. guitar",
	"     strat",
	"     strat",
	"   ac bass",
	" pull bass",
	" pull bass",
	"round bass",
	" slap bass",
	" slap bass",
	" slap bass",
	"  fretless",
	"  fretless",
	"synth bass",
	"synth bass",
	" harmonica",
	"  clarinet",
	"  clarinet",
	"      oboe",
	"      oboe",
	"shakuhachi",
	"oriental bell",
	"oriental bell",
	"      bell",
	"      koto",
	"     sitar",
	"    e. tom",
	"  log drum",
	"  log drum",
	"steel drum",
	"steel drum",
	"   voice 1",
	"   voice 2",
	" accordion",
	" accordion",
	"jass organ2",
	"rock organ1",
	"draw bar 1",
	"draw bar 2",
	"pipe organ1",
	"pipe organ2",
	"rock organ2",
	"synth solo",
	"synth solo",
	"synth 2",
	"synth 2",
	"synth 3",
	"brass",
	"brass",
	"orchestra",
	"piano 1",
	"piano 4",
	"e. piano 1",
	"e. piano 1",
	"e. piano 2",
	"e. piano 3",
	"clavi",
	"harpsichord",
	"harpsichord",
	"vibe",
	"digi bass 1",
	"digi bass 2",
	"digi bass 2",
	"pick bass",
	"glocken",
	"glocken",
	"tine",
	"tine",
	"tine",
	"tube bell",
	"tube bell",
	"tube bell",
	"xylophone",
	"xylophone",
	"harp",
	"koto",
	"sitar",
	"sitar",
	"kalimba",
	"kalimba",
	"kalimba",
	"log drum",
	"steel drum",
	"pipe organ 3",
	"pipe organ 3",
	"synth 1",
	"synth 2",
	"synth 3",
	"synth 3",
	"synth 4",
	"synth 4",
	"clavi",
	"digi bass 1",
	"digi bass 1",
	"pick bass",
	"pick bass",
	"round bass",
	"round bass",
	"harmonica",
	"harmonica",
	"harp",
	"koto",
	"sitar",
	"marimba",
	"synth 1",
	"base drum",
	"ac snare",
	"tight snare",
	"e. snare",
	"rim",
	"ac tom",
	"h. hat",
	"crach",
	"ride",
	"strat guitar",
	"fuzz mute",
	"a. guitar",
	"f. guitar",
	"guitar harmo",
	"pull bass",
	"bass harmo",
	"bowed string",
	"string attack",
	"string sus",
	"pizzicato",
	"piano",
	"el. grand",
	"piano noise",
	"trumpet",
	"shakuhachi attack",
	"shakuhachi sus",
	"pan flute attack",
	"pan flute sus",
	"voice",
	"white noise",
	"string loop",
	"shakuhachi loop",
	"pan flute loop",
	"voice loop",
	"white noise loop",
	"ac snare loop",
	"f. guitar loop",
	"pull bass loop",
	"omn. loop 1",
	"omn. loop 2",
	"omn. loop 3",
	"omn. loop 4",
	"omn. loop 5",
	"omn. loop 6",
	"omn. loop 7",
	"omn. loop 8",
	"ac snare rev",
	"ac tom rev",
	"f. guitar rev",
	"h. hat alt",
	"crash alt",
	"piano noise alt"
};

char *
viswave(v)
{	static char wavebuf[30];

	if (v >= 0 && v <= 255) {
		(void)sprintf(wavebuf, "%3d %s", v+1, wave_table[v]);
		return(wavebuf);
	}
	return("*");
}

/* end */
