#
# Config file to build on sgi Indigo running Irix4.x
#
# @(#)config-irix4.mk	1.6 4/19/94
#	Programmer: Christopher Hylands

# --------------------------------------------------------------------
# |  Please see the file ``config-default.mk'' in this directory!    |
# --------------------------------------------------------------------
include $(ROOT)/mk/config-default.mk

# Get the g++ definitions; we override some below.
include $(ROOT)/mk/config-g++.mk

#
# Programs to use
#
RANLIB =	ranlib
# Use gcc everywhere _except_ in octtools
CC =		gcc
OPTIMIZER =	-O2
WARNINGS =	-Wall -Wcast-qual -Wcast-align

# Use -D_BSD_SIGNALS for src/kernel/SimControl.cc
#  see /usr/include/sys/signals.h for more info.
MISC_DEFINES =	-D_BSD_SIGNALS

GPPFLAGS =	-G 0 $(MEMLOG) $(WARNINGS) $(MISC_DEFINES) $(OPTIMIZER)

#     -cckr   The traditional K&R/Version7 C with SGI extensions
CFLAGS =	-G 0 -g -cckr $(OPTIMIZER)

#
# Variables for the linker
#
SYSLIBS =	-lg++ -lm -lmld

# -N flags causes 'syntax errors' at runtime under irix4
#	./ptcl: syntax error at line 2: `(' unexpected
# Without the -N flag, it is doubtful if dynamic linking will work
LINKFLAGS =	-L$(LIBDIR) -G 0 -Xlinker -x
LINKFLAGS_D =	-L$(LIBDIR) -G 0

#
# Directories to use
#
X11_INCSPEC = -I/usr/X11/include
X11_LIBSPEC = -L/usr/X11/lib -lX11


# S56 directory is only used on sun4.
S56DIR =

#
# Variables for miscellaneous programs
#

# Used by xv
#XV_RAND= RAND="-DNO_RANDOM -Drandom=rand"
XV_INSTALL = 	/usr/bin/X11/bsdinst.sh
XV_CC = 	"cc -cckr -DSVR4"
