/*
    GRAPH0.C
    Define graphics related functions.

    $Id$
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

extern long FindMeshZone(double xx, double yy, double *x, double *y,
			 int *reg, long ix, long jx);

/*--------------------------------------------------------------------------*/

/* return -1 if (xx,yy) not within ix-by-jx mesh (x,y),
   else 0-origin zone index -- reg==0 is allowed, and reg
   need not have overreach zones */
long FindMeshZone(double xx, double yy, double *x, double *y,
		  int *reg, long ix, long jx)
{
  int wind= 0;   /* winding number of zone around (xx,yy) */
  long i, i0, ijx= ix*jx;
  /* coordinates of zone corners relative to (xx,yy) */
  double x00, y00, x01, y01, x10, y10, x11, y11;

  i0= 0;
  for (i=ix+1 ; i<ijx ; i++) {
    if ((++i0)==ix) { i0= 1; i++; }  /* skip 1st point of each row */
    if (reg && !reg[i]) continue;   /* skip non-existent zones */
    /* initialize 00 and 10 points at beginning of a row or
       after a non-existent zone */
    x00= x[i-ix-1]-xx;   y00= y[i-ix-1]-yy;
    x10= x[i-1]-xx;      y10= y[i-1]-yy;

    x01= x[i-ix]-xx;     y01= y[i-ix]-yy;
    x11= x[i]-xx;        y11= y[i]-yy;

    /* hopefully spend most of the time in these fast scan loops
       with all four points in one quadrant relative to (xx,yy) */
    if (ix<8) goto test;  /* pointless if rows too short */
    if (x11<0.0) {
      if (x01<0.0 && x10<0.0 && x00<0.0) {
      left:
	for (i++ ; ; i++) {
	  if (i>=ijx) goto done;
	  if ((++i0)==ix) { i0= 0; goto abort; }
	  if (reg && !reg[i]) goto abort;
	  x01= x[i-ix]-xx;   x11= x[i]-xx;
	  if (x01>=0.0 || x11>=0.0) break;
	}
	y00= y[i-ix-1]-yy;   y10= y[i-1]-yy;
	y01= y[i-ix]-yy;     y11= y[i]-yy;
	if (y11<0.0) {
	  if (y01<0.0 && y10<0.0 && y00<0.0) goto low;
	} else {
	  if (y01>=0.0 && y10>=0.0 && y00>=0.0) goto high;
	}
	x00= x[i-ix-1]-xx;   x10= x[i-1]-xx;
	goto test;
      }

    } else {
      if (x01>=0.0 && x10>=0.0 && x00>=0.0) {
      right:
	for (i++ ; ; i++) {
	  if (i>=ijx) goto done;
	  if ((++i0)==ix) { i0= 0; goto abort; }
	  if (reg && !reg[i]) goto abort;
	  x01= x[i-ix]-xx;   x11= x[i]-xx;
	  if (x01<0.0 || x11<0.0) break;
	}
	y00= y[i-ix-1]-yy;   y10= y[i-1]-yy;
	y01= y[i-ix]-yy;     y11= y[i]-yy;
	if (y11<0.0) {
	  if (y01<0.0 && y10<0.0 && y00<0.0) goto low;
	} else {
	  if (y01>=0.0 && y10>=0.0 && y00>=0.0) goto high;
	}
	x00= x[i-ix-1]-xx;   x10= x[i-1]-xx;
	goto test;
      }
    }

    if (y11<0.0) {
      if (y01<0.0 && y10<0.0 && y00<0.0) {
      low:
	for (i++ ; ; i++) {
	  if (i>=ijx) goto done;
	  if ((++i0)==ix) { i0= 0; goto abort; }
	  if (reg && !reg[i]) goto abort;
	  y01= y[i-ix]-yy;   y11= y[i]-yy;
	  if (y01>=0.0 || y11>=0.0) break;
	}
	x00= x[i-ix-1]-xx;   x10= x[i-1]-xx;
	x01= x[i-ix]-xx;     x11= x[i]-xx;
	if (x11<0.0) {
	  if (x01<0.0 && x10<0.0 && x00<0.0) goto left;
	} else {
	  if (x01>=0.0 && x10>=0.0 && x00>=0.0) goto right;
	}
	y00= y[i-ix-1]-yy;   y10= y[i-1]-yy;
	goto test;
      }

    } else {
      if (y01>=0.0 && y10>=0.0 && y00>=0.0) {
      high:
	for (i++ ; ; i++) {
	  if (i>=ijx) goto done;
	  if ((++i0)==ix) { i0= 0; goto abort; }
	  if (reg && !reg[i]) goto abort;
	  y01= y[i-ix]-yy;   y11= y[i]-yy;
	  if (y01<0.0 || y11<0.0) break;
	}
	x00= x[i-ix-1]-xx;   x10= x[i-1]-xx;
	x01= x[i-ix]-xx;     x11= x[i]-xx;
	if (x11<0.0) {
	  if (x01<0.0 && x10<0.0 && x00<0.0) goto left;
	} else {
	  if (x01>=0.0 && x10>=0.0 && x00>=0.0) goto right;
	}
	y00= y[i-ix-1]-yy;   y10= y[i-1]-yy;
	goto test;
      }
    }

  test:
    /* compute counterclockwise crossings of x==xx for each of the
       four edges of the zone */
    wind= 0;
    if ((x00<0.0)^(x01<0.0)) {
      if (x00*y01>x01*y00) wind++;
      else wind--;
    }
    if ((x01<0.0)^(x11<0.0)) {
      if (x01*y11>x11*y01) wind++;
      else wind--;
    }
    if ((x11<0.0)^(x10<0.0)) {
      if (x11*y10>x10*y11) wind++;
      else wind--;
    }
    if ((x10<0.0)^(x00<0.0)) {
      if (x10*y00>x00*y10) wind++;
      else wind--;
    }
    if (wind) break;  /* this zone winds around (xx,yy) */

  abort:
    continue;
  }
 done:

  return wind? i : -1;
}

/*--------------------------------------------------------------------------*/
