/*
   TESTM.I
   Certify functions in fft.i and matrix.i

   $Id$
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

func testm
{
  write, "testing fft routines...";
  fft_test, 95;
  fft_test, 32;
  fft_test, 12;
  write, "testing LU decomposition routine...";
  testLU, 75;
  testLU, 16;
}

func fft_test(n)
{
  index= 2*pi*(indgen(n)-1.0)/n;
  z= sin(index*3);
  zf= fft(z, 1);
  z3= z2= array(0i, n);
  z3(4)= -0.5i*n;
  z3(-2)= 0.5i*n;
  zb= fft(z, -1);
  if (max(abs(zf-z3))>1.e-12*n || max(abs(zb-conj(z3)))>1.e-12*n)
    write, "***WARNING*** failed 1D fft test";
  if (n<=96 || force2d) {
    z*= cos(index*2)(-,);
    zf= fft(z, [0, 1]);
    z2(3)= z2(-1)= 0.5*n;
    zb= fft(z, [], [-1, 0]);
    if (max(abs(zf-sin(index*3)*z2(-,)))>1.e-12*n ||
	max(abs(zb-conj(z3)*cos(index*2)(-,)))>1.e-12*n)
      write, "***WARNING*** failed first 2D fft test";
    zf= fft(z, 1);
    zb= fft(z, -1);
    if (max(abs(zf-z3*z2(-,)))>1.e-12*n ||
	max(abs(zb-conj(z3)*z2(-,)))>1.e-12*n)
      write, "***WARNING*** failed second 2D fft test";
  }
}

func TDcheck(c, d, e, b, x, s)
{
  check= _(   d(1)*x(1)    +    e(1)*x(2),
	   c(1:-1)*x(1:-2) + d(2:-1)*x(2:-1) + e(2:0)*x(3:0),
	                        c(0)*x(-1)   +   d(0)*x(0)   );
  if (max(abs(check-b))>1.e-9*max(abs(b))) {
    write, "***WARNING*** "+s+" tridiagonal solution doesn't check";
    write, "   max relative error is "+pr1((max(abs(check-b)))/max(abs(b)));
  }
}

func testTD(n)
{
  c= random(n-1);
  d= random(n);
  e= random(n-1);
  b= random(n);
  TDcheck,c,d,e,b,TDsolve(c,d,e,b), "1D";
  b2= random(n);
  x= TDsolve(c,d,e,[b,b2])
  TDcheck,c,d,e,b, x(,1), "2D(1)";
  TDcheck,c,d,e,b2, x(,2), "2D(2)";
  x= TDsolve(c,d,e,transpose([b,b2]), which=2)
  TDcheck,c,d,e,b, x(1,), "2D(1)/which";
  TDcheck,c,d,e,b2, x(2,), "2D(2)/which";
}

func LUcheck(a, b, x, s)
{
  check= a(,+)*x(+);
  if (max(abs(check-b))>1.e-9*max(abs(b))) {
    write, "***WARNING*** "+s+" LUsolve solution doesn't check";
    write, "   max relative error is "+pr1((max(abs(check-b)))/max(abs(b)));
  }
}

func testLU(n)
{
  a= random(n,n);
  b= random(n);
  LUcheck,a,b,LUsolve(a,b), "1D";
  b2= random(n);
  x= LUsolve(a,[b,b2])
  LUcheck,a,b, x(,1), "2D(1)";
  LUcheck,a,b2, x(,2), "2D(2)";
  x= LUsolve(transpose(a),[b,b2])
  LUcheck,transpose(a),b, x(,1), "t2D(1)";
  LUcheck,transpose(a),b2, x(,2), "t2D(2)";
  x= LUsolve(a,transpose([b,b2]), which=2)
  LUcheck,a,b, x(1,), "2D(1)/which";
  LUcheck,a,b2, x(2,), "2D(2)/which";
  x= LUsolve(transpose(a),transpose([b,b2]), which=2)
  LUcheck,transpose(a),b, x(1,), "t2D(1)/which";
  LUcheck,transpose(a),b2, x(2,), "t2D(2)/which";
  ai= LUsolve(a);
  err= max(abs(ai(,+)*a(+,)-unit(n)))/max(abs(ai));
  if (err>1.e-9) {
    write, "***WARNING*** LUsolve inverse is fishy";
    write, "   max relative error is "+pr1(err);
  }
}
