*  -- Yorick wrappers for LAPACK routines:
*      dgecon - estimates matrix condition number
*     plus XERBLA routine appropriate to Yorick
*
      SUBROUTINE DGECOX( NORM, N, A, LDA, ANORM, RCOND, WORK, IWORK,
     $                   INFO )
*
*  Purpose
*  =======
*
*  DGECOX is a wrapper for DGECON, more easily callable from non-FORTRAN
*  language routines (no gratuitous string argument).
*
*  Arguments
*  =========
*
*  NORM    (input) INTEGER
*          Specifies whether the 1-norm condition number or the
*          infinity-norm condition number is required:
*          = 1:           1-norm;
*          = 0:           Infinity-norm.
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER NRM
      IF ( NORM.NE.0 ) THEN
         NRM = '1'
      ELSE
         NRM = 'I'
      ENDIF
      CALL DGECON( NRM, N, A, LDA, ANORM, RCOND, WORK, IWORK, INFO )
      RETURN
      END
      SUBROUTINE XERBLA( SRNAME, INFO )
*
*  -- LAPACK auxiliary routine (version 1.1) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      CHARACTER*6        SRNAME
      INTEGER            INFO
*     ..
*
*  Purpose
*  =======
*
*  XERBLA  is an error handler for the LAPACK routines.
*  It is called by an LAPACK routine if an input parameter has an
*  invalid value.  A message is printed and execution stops.
*
*  Installers may consider modifying the STOP statement in order to
*  call system-specific exception-handling facilities.
*
*  Modified for use with Yorick.  Calls FBLOWUP, unless these are the
*  calls used to determine the workspace size for DGELS, DGELSS, or DGESVD.
*
*  Arguments
*  =========
*
*  SRNAME  (input) CHARACTER*6
*          The name of the routine which called XERBLA.
*
*  INFO    (input) INTEGER
*          The position of the invalid parameter in the parameter list
*          of the calling routine.
*
*     .. Executable Statements ..
*
      IF ( SRNAME.EQ.'DGELS ' .AND. INFO.EQ.10 ) THEN
         RETURN
      ELSE IF ( SRNAME.EQ.'DGELSS' .AND. INFO.EQ.12 ) THEN
         RETURN
      ELSE IF ( SRNAME.EQ.'DGESVD' .AND. INFO.EQ.13 ) THEN
         RETURN
      ELSE
         CALL FBLOWUP('(BUG) LAPACK input error -- XERBLA called')
         RETURN
      ENDIF
*     WRITE( *, FMT = 9999 )SRNAME, INFO
*
*     STOP
*
*9999 FORMAT( ' ** On entry to ', A6, ' parameter number ', I2, ' had ',
*    $      'an illegal value' )
*
*     End of XERBLA
*
      END
