      subroutine funtab(id,fptr,job)
c     ====================================================================
c!but
c     funtab gere et lit la table des primitives
c!liste d'appel
c     job : indicateur  de l'operation a effectuer
c     0 impression de la table des primitives id et fptr ne sont pas
c             references
c     1 recherche du pointeur fptr associe au nom id, le sous programme
c             retourne la valeur du pointeur dans fptr. S'il n'y a pas
c             de fonction correspondant a id funtab retourne fptr=0
c             si id est un nom incorrect funtab retourne fptr=-1
c     2 recherche du nom id associe au pointeur fptr s'il n'y a pas
c             de fonction associee a ce pointeur funtab retourne
c             id(1)=0
c     3 ajout du nom donne par id avec le pointeur donne par fptr
c             en cas d'erreur (nom incorrecte ou capacite de la table
c             depasse funtab appele error et retourne avec err>0
c     4 suppression du nom donne par id, le sous programme retourne
c             la valeur du pointeur associe dans fptr. S'il n'y a pas
c             de fonction correspondant a id funtab retourne fptr=0
c             si id est un nom incorrect funtab retourne fptr=-1
c
c     id  :vecteur de taille nsiz contenant le code scilab du nom
c     fptr:entier
c!remarque
c     ce sous programme peut etre regenere automatiquement par le
c     programme newfun a partir de sa version courante et du fichier
c     fundef.
c!
c     ====================================================================
c
      include '../stack.h'
      integer   nfree
      parameter (nfree=50)
c
      integer id(*),fptr,job
      logical eqid
      integer point(27)
      integer mxf
c+
      parameter (mxf=nfree+258)
      integer funl,funl1,funn(nsiz,mxf),funp(mxf)
      parameter (funl1= 49)
      integer funm(nsiz,funl1)
      common /funcs/funl,funn,funp
      data funl/258/
c    1 abs                     
c    2 addf                    
c    3 amell                   
c    4 argn                    
c    5 arl2                    
c    6 atan                    
c    7 adj2l                   
c    8 balanc                  
c    9 bdiag                   
c    a bezout                  
c    1 bva                     
c    2 busack                  
c    3 champ                   
c    4 chol                    
c    5 clearfun                
c    6 coeff                   
c    7 comp                    
c    8 cond                    
c    9 conj                    
c    a contour                 
c    1 contr                   
c    2 convstr                 
c    3 corr                    
c    4 cos                     
c    5 clean                   
c    6 createg                 
c    7 compl2                  
c    8 compht                  
c    9 compunl1                
c    a compla                  
c    1 connex                  
c    2 concom                  
c    3 chcm                    
c    4 dassl                   
c    5 debug                   
c    6 deff                    
c    7 degree                  
c    8 delbpt                  
c    9 delip                   
c    a det                     
c    1 diag                    
c    2 diary                   
c    3 disp                    
c    4 dispbpt                 
c    5 driver                  
c    6 dijkst                  
c    7 dfs                     
c    8 dmtree                  
c    9 emptystr                
c    a ereduc                  
c    1 errcatch                
c    2 errclear                
c    3 error                   
c    4 exec                    
c    5 execstr                 
c    6 exists                  
c    7 exp                     
c    8 eye                     
c    9 edge2st                 
c    a euler                   
c    1 fec                     
c    2 feval                   
c    3 fft                     
c    4 file                    
c    5 find                    
c    6 format                  
c    7 fort                    
c    8 freq                    
c    9 fsolve                  
c    a fstair                  
c    1 funptr                  
c    2 full                    
c    3 ford                    
c    4 frank                   
c    5 geom3d                  
c    6 getenv                  
c    7 getf                    
c    8 getpid                  
c    9 grayplot                
c    a gschur                  
c    1 gspec                   
c    2 havewindow              
c    3 hess                    
c    4 host                    
c    5 idialog                 
c    6 imag                    
c    7 impl                    
c    8 int                     
c    9 interp                  
c    a intg                    
c    1 inv                     
c    2 iserror                 
c    3 inimet                  
c    4 isconnex                
c    5 johns                   
c    6 kron                    
c    7 kilter                  
c    8 ldiv                    
c    9 ldivf                   
c    a length                  
c    1 lib                     
c    2 lines                   
c    3 link                    
c    4 list                    
c    5 load                    
c    6 log                     
c    7 ltitr                   
c    8 lu                      
c    9 ludel1                  
c    a lufact1                 
c    1 lusolve1                
c    2 lyap                    
c    3 lufact                  
c    4 lusolve                 
c    5 ludel                   
c    6 luget                   
c    7 loadg                   
c    8 l2adj                   
c    9 macprt                  
c    a macr2lst                
c    1 matrix                  
c    2 max                     
c    3 maxi                    
c    4 min                     
c    5 mini                    
c    6 mode                    
c    7 mulf                    
c    8 maxflow                 
c    9 minqflow                
c    a maxcpl                  
c    1 mincfr                  
c    2 newfun                  
c    3 norm                    
c    4 notify                  
c    5 nnz                     
c    6 netwindow               
c    7 netwindows              
c    8 ns2p                    
c    9 ode                     
c    a ones                    
c    1 optim                   
c    2 param3d                 
c    3 part                    
c    4 pinv                    
c    5 plot2d                  
c    6 plot2d1                 
c    7 plot2d2                 
c    8 plot2d3                 
c    9 plot2d4                 
c    a plot3d                  
c    1 plot3d1                 
c    2 poly                    
c    3 ppol                    
c    4 pppdiv                  
c    5 predef                  
c    6 print                   
c    7 prod                    
c    8 prevn2p                 
c    9 p2ns                    
c    a prevn2st                
c    1 pcchna                  
c    2 pccsc                   
c    3 qpqpqp                  
c    4 qr                      
c    5 rand                    
c    6 rank                    
c    7 rcond                   
c    8 rdivf                   
c    9 read                    
c    a readb                   
c    1 real                    
c    2 remez                   
c    3 residu                  
c    4 resume                  
c    5 return                  
c    6 ricc                    
c    7 roots                   
c    8 round                   
c    9 rpem                    
c    a rref                    
c    1 rtitr                   
c    2 save                    
c    3 schur                   
c    4 sconvert                
c    5 setbpt                  
c    6 sfact                   
c    7 sign                    
c    8 simp                    
c    9 sin                     
c    a size                    
c    1 sort                    
c    2 spec                    
c    3 splin                   
c    4 sqrt                    
c    5 string                  
c    6 subf                    
c    7 sum                     
c    8 sva                     
c    9 svd                     
c    a sylv                    
c    1 syredi                  
c    2 sparse                  
c    3 spget                   
c    4 semidef                 
c    5 showns                  
c    6 showp                   
c    7 sconnex                 
c    8 sconcom                 
c    9 timer                   
c    a tr_zer                  
c    1 tril                    
c    2 triu                    
c    3 type                    
c    4 transc                  
c    5 unix                    
c    6 user                    
c    7 umtree                  
c    8 umtree1                 
c    9 varn                    
c    a where                   
c    1 whereis                 
c    2 writb                   
c    3 write                   
c    4 x_choose                
c    5 x_dialog                
c    6 x_mdialog               
c    7 x_message               
c    8 xarc                    
c    9 xarcs                   
c    a xarrows                 
c    1 xaxis                   
c    2 xchange                 
c    3 xclea                   
c    4 xclear                  
c    5 xclick                  
c    6 xend                    
c    7 xfarc                   
c    8 xfpoly                  
c    9 xfpolys                 
c    a xfrect                  
c    1 xget                    
c    2 xgetech                 
c    3 xgetmouse               
c    4 xinit                   
c    5 xlfont                  
c    6 xnumb                   
c    7 xpause                  
c    8 xpoly                   
c    9 xpolys                  
c    a xrect                   
c    1 xrects                  
c    2 xsegs                   
c    3 xselect                 
c    4 xset                    
c    5 xsetech                 
c    6 xstring                 
c    7 xstringl                
c    8 xtape                   
      data ((funn(i,j),i=1,nsiz),j=  1, 10)/
     1 672926474,673720360,673720360,673720360,673720360,673720360,
     2 252513546,673720360,673720360,673720360,673720360,673720360,
     3 353244682,673720341,673720360,673720360,673720360,673720360,
     4 386931466,673720360,673720360,673720360,673720360,673720360,
     5  34937610,673720360,673720360,673720360,673720360,673720360,
     6 386538762,673720360,673720360,673720360,673720360,673720360,
     7  34802954,673720341,673720360,673720360,673720360,673720360,
     8 169150987,673713175,673720360,673720360,673720360,673720360,
     9 168955147,673720336,673720360,673720360,673720360,673720360,
     a 404950539,673717534,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 11, 20)/
     1 671751947,673720360,673720360,673720360,673720360,673720360,
     2 169614859,673715212,673720360,673720360,673720360,673720360,
     3 369758476,673720345,673720360,673720360,673720360,673720360,
     4 353898764,673720360,673720360,673720360,673720360,673720360,
     5 168695052,387845915,673720360,673720360,673720360,673720360,
     6 252581900,673720335,673720360,673720360,673720360,673720360,
     7 420878348,673720360,673720360,673720360,673720360,673720360,
     8 219617292,673720360,673720360,673720360,673720360,673720360,
     9 320280588,673720360,673720360,673720360,673720360,673720360,
     a 488052748,672865816,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 21, 30)/
     1 488052748,673720347,673720360,673720360,673720360,673720360,
     2 521607180,672865564,673720360,673720360,673720360,673720360,
     3 454760460,673720360,673720360,673720360,673720360,673720360,
     4 672929804,673720360,673720360,673720360,673720360,673720360,
     5 168695052,673720343,673720360,673720360,673720360,673720360,
     6 168696588,672140829,673720360,673720360,673720360,673720360,
     7 420878348,673710613,673720360,673720360,673720360,673720360,
     8 420878348,673717521,673720360,673720360,673720360,673720360,
     9 420878348, 18159390,673720360,673720360,673720360,673720360,
     a 420878348,673712661,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 31, 40)/
     1 387389452,673718542,673720360,673720360,673720360,673720360,
     2 202840076,673715736,673720360,673720360,673720360,673720360,
     3 369889548,673720360,673720360,673720360,673720360,673720360,
     4 471599629,673720341,673720360,673720360,673720360,673720360,
     5 504040973,673720336,673720360,673720360,673720360,673720360,
     6 252644877,673720360,673720360,673720360,673720360,673720360,
     7 454037005,673713678,673720360,673720360,673720360,673720360,
     8 185929229,673717529,673720360,673720360,673720360,673720360,
     9 303369741,673720345,673720360,673720360,673720360,673720360,
     a 672992781,673720360,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 41, 50)/
     1 269095437,673720360,673720360,673720360,673720360,673720360,
     2 453644813,673720354,673720360,673720360,673720360,673720360,
     3 421270029,673720360,673720360,673720360,673720360,673720360,
     4 421270029,672995595,673720360,673720360,673720360,673720360,
     5 521280269,673717006,673720360,673720360,673720360,673720360,
     6 336794125,673717532,673720360,673720360,673720360,673720360,
     7 672927501,673720360,673720360,673720360,673720360,673720360,
     8 454891021,673713678,673720360,673720360,673720360,673720360,
     9 488183310,454892578,673720360,673720360,673720360,673720360,
     a 219028238,673713182,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 51, 60)/
     1 203102990,286006538,673720360,673720360,673720360,673720360,
     2 203102990,453643797,673720360,673720360,673720360,673720360,
     3 404429582,673720347,673720360,673720360,673720360,673720360,
     4 202252558,673720360,673720360,673720360,673720360,673720360,
     5 202252558,672865564,673720360,673720360,673720360,673720360,
     6 470950158,673717277,673720360,673720360,673720360,673720360,
     7 672735502,673720360,673720360,673720360,673720360,673720360,
     8 672014862,673720360,673720360,673720360,673720360,673720360,
     9 235932942,672996354,673720360,673720360,673720360,673720360,
     a 236264974,673720347,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 61, 70)/
     1 671878671,673720360,673720360,673720360,673720360,673720360,
     2 169807375,673720341,673720360,673720360,673720360,673720360,
     3 672993039,673720360,673720360,673720360,673720360,673720360,
     4 236261903,673720360,673720360,673720360,673720360,673720360,
     5 219615759,673720360,673720360,673720360,673720360,673720360,
     6 370874383,673717514,673720360,673720360,673720360,673720360,
     7 488314895,673720360,673720360,673720360,673720360,673720360,
     8 437132047,673720360,673720360,673720360,673720360,673720360,
     9 353901583,673713695,673720360,673720360,673720360,673720360,
     a 169679887,673717010,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 71, 80)/
     1 420945423,673717021,673720360,673720360,673720360,673720360,
     2 353705487,673720360,673720360,673720360,673720360,673720360,
     3 219879439,673720360,673720360,673720360,673720360,673720360,
     4 386538255,673720340,673720360,673720360,673720360,673720360,
     5 370675216,673713411,673720360,673720360,673720360,673720360,
     6 236785168,673718039,673720360,673720360,673720360,673720360,
     7 253562384,673720360,673720360,673720360,673720360,673720360,
     8 421334544,673713426,673720360,673720360,673720360,673720360,
     9 571087632,488117529,673720360,673720360,673720360,673720360,
     a 286006288,673717022,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 81, 90)/
     1 236526608,673720332,673720360,673720360,673720360,673720360,
     2 236915217,219615776,673718296,673720360,673720360,673720360,
     3 471600657,673720360,673720360,673720360,673720360,673720360,
     4 488380433,673720360,673720360,673720360,673720360,673720360,
     5 168955154,672143381,673720360,673720360,673720360,673720360,
     6 269096466,673720360,673720360,673720360,673720360,673720360,
     7 353965586,673720360,673720360,673720360,673720360,673720360,
     8 672995090,673720360,673720360,673720360,673720360,673720360,
     9 236787474,673716507,673720360,673720360,673720360,673720360,
     a 270341906,673720360,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j= 91,100)/
     1 673126162,673720360,673720360,673720360,673720360,673720360,
     2 453909522,672864283,673720360,673720360,673720360,673720360,
     3 370284306,673717518,673720360,673720360,673720360,673720360,
     4 403446802,554571543,673720360,673720360,673720360,673720360,
     5 386996243,673720348,673720360,673720360,673720360,673720360,
     6 387455764,673720360,673720360,673720360,673720360,673720360,
     7 487920148,673717006,673720360,673720360,673720360,673720360,
     8 521276693,673720360,673720360,673720360,673720360,673720360,
     9 521276693,673720335,673720360,673720360,673720360,673720360,
     a 269946389,673714461,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=101,110)/
     1 671814165,673720360,673720360,673720360,673720360,673720360,
     2 236392981,673720348,673720360,673720360,673720360,673720360,
     3 337056277,673720360,673720360,673720360,673720360,673720360,
     4 488378901,673720360,673720360,673720360,673720360,673720360,
     5 218765333,673720360,673720360,673720360,673720360,673720360,
     6 672143381,673720360,673720360,673720360,673720360,673720360,
     7 487726357,673720347,673720360,673720360,673720360,673720360,
     8 673717781,673720360,673720360,673720360,673720360,673720360,
     9 235740693,673710357,673720360,673720360,673720360,673720360,
     a 168762901,671161612,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=111,120)/
     1 404495893, 17702677,673720360,673720360,673720360,673720360,
     2 420094485,673720360,673720360,673720360,673720360,673720360,
     3 168762901,673717516,673720360,673720360,673720360,673720360,
     4 404495893,672014101,673720360,673720360,673720360,673720360,
     5 235740693,673720341,673720360,673720360,673720360,673720360,
     6 235937301,673720349,673720360,673720360,673720360,673720360,
     7 218765333,673720336,673720360,673720360,673720360,673720360,
     8 218759701,673720339,673720360,673720360,673720360,673720360,
     9 420219414,673717531,673720360,673720360,673720360,673720360,
     a 453773846,488379650,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=121,130)/
     1 454887958,673718546,673720360,673720360,673720360,673720360,
     2 673253910,673720360,673720360,673720360,673720360,673720360,
     3 304155158,673720360,673720360,673720360,673720360,673720360,
     4 672600598,673720360,673720360,673720360,673720360,673720360,
     5 303501846,673720360,673720360,673720360,673720360,673720360,
     6 235739158,673720360,673720360,673720360,673720360,673720360,
     7 253042198,673720360,673720360,673720360,673720360,673720360,
     8 253823510,673191957,673720360,673720360,673720360,673720360,
     9 437719574,538449167,673720360,673720360,673720360,673720360,
     a 203491862,673715481,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=131,140)/
     1 202838550,673717007,673720360,673720360,673720360,673720360,
     2 253758999,673715998,673720360,673720360,673720360,673720360,
     3 370874391,673720360,673720360,673720360,673720360,673720360,
     4 303896599,673718799,673720360,673720360,673720360,673720360,
     5 673388311,673720360,673720360,673720360,673720360,673720360,
     6 538775063,403511058,673720352,673720360,673720360,673720360,
     7 538775063,403511058,673717280,673720360,673720360,673720360,
     8 419568663,673720360,673720360,673720360,673720360,673720360,
     9 672009496,673720360,673720360,673720360,673720360,673720360,
     a 470685464,673720360,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=141,150)/
     1 303896856,673720342,673720360,673720360,673720360,673720360,
     2 169544217,671941398,673720360,673720360,673720360,673720360,
     3 488311321,673720360,673720360,673720360,673720360,673720360,
     4 521605657,673720360,673720360,673720360,673720360,673720360,
     5 488117529,673713410,673720360,673720360,673720360,673720360,
     6 488117529,671157506,673720360,673720360,673720360,673720360,
     7 488117529,671223042,673720360,673720360,673720360,673720360,
     8 488117529,671288578,673720360,673720360,673720360,673720360,
     9 488117529,671354114,673720360,673720360,673720360,673720360,
     a 488117529,673713411,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=151,160)/
     1 488117529,671157507,673720360,673720360,673720360,673720360,
     2 571807769,673720360,673720360,673720360,673720360,673720360,
     3 353900825,673720360,673720360,673720360,673720360,673720360,
     4 219748633,673718034,673720360,673720360,673720360,673720360,
     5 219028249,673713934,673720360,673720360,673720360,673720360,
     6 387062553,673720349,673720360,673720360,673720360,673720360,
     7 219683609,673720360,673720360,673720360,673720360,673720360,
     8 521018137,672727575,673720360,673720360,673720360,673720360,
     9 471269913,673720360,673720360,673720360,673720360,673720360,
     a 521018137,488374807,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=161,170)/
     1 286002201,673712663,673720360,673720360,673720360,673720360,
     2 470551577,673720332,673720360,673720360,673720360,673720360,
     3 421140762,673716506,673720360,673720360,673720360,673720360,
     4 673717018,673720360,673720360,673720360,673720360,673720360,
     5 219613723,673720360,673720360,673720360,673720360,673720360,
     6 337054235,673720360,673720360,673720360,673720360,673720360,
     7 387451931,673720333,673720360,673720360,673720360,673720360,
     8 521276699,673720335,673720360,673720360,673720360,673720360,
     9 218762779,673720360,673720360,673720360,673720360,673720360,
     a 218762779,673720331,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=171,180)/
     1 352980507,673720360,673720360,673720360,673720360,673720360,
     2 236326427,673720355,673720360,673720360,673720360,673720360,
     3 303828507,673717773,673720360,673720360,673720360,673720360,
     4 505155099,673713686,673720360,673720360,673720360,673720360,
     5 505220635,673715995,673720360,673720360,673720360,673720360,
     6 202117659,673720360,673720360,673720360,673720360,673720360,
     7 488118299,673720348,673720360,673720360,673720360,673720360,
     8 387848219,673720333,673720360,673720360,673720360,673720360,
     9 370022683,673720360,673720360,673720360,673720360,673720360,
     a 252582683,673720360,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=181,190)/
     1 487726363,673720347,673720360,673720360,673720360,673720360,
     2 236915228,673720360,673720360,673720360,673720360,673720360,
     3 504433692,673720347,673720360,673720360,673720360,673720360,
     4 387451932,488312351,673720360,673720360,673720360,673720360,
     5 186453532,673717529,673720360,673720360,673720360,673720360,
     6 201985820,673720349,673720360,673720360,673720360,673720360,
     7 386929180,673720360,673720360,673720360,673720360,673720360,
     8 420876828,673720360,673720360,673720360,673720360,673720360,
     9 672600604,673720360,673720360,673720360,673720360,673720360,
     a 237179420,673720360,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=191,200)/
     1 488314908,673720360,673720360,673720360,673720360,673720360,
     2 202250524,673720360,673720360,673720360,673720360,673720360,
     3 303372572,673720343,673720360,673720360,673720360,673720360,
     4 488315420,673720360,673720360,673720360,673720360,673720360,
     5 303766812,673714199,673720360,673720360,673720360,673720360,
     6 252386844,673720360,673720360,673720360,673720360,673720360,
     7 672538140,673720360,673720360,673720360,673720360,673720360,
     8 671751964,673720360,673720360,673720360,673720360,673720360,
     9 671948572,673720360,673720360,673720360,673720360,673720360,
     a 521478684,673720360,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=201,210)/
     1 236659228,673714701,673720360,673720360,673720360,673720360,
     2 453646620,673713692,673720360,673720360,673720360,673720360,
     3 235936028,673720349,673720360,673720360,673720360,673720360,
     4 303435292,672075277,673720360,673720360,673720360,673720360,
     5 538448156,673717271,673720360,673720360,673720360,673720360,
     6 538448156,673720345,673720360,673720360,673720360,673720360,
     7 387451932,673254935,673720360,673720360,673720360,673720360,
     8 387451932,672536588,673720360,673720360,673720360,673720360,
     9 236327453,673720347,673720360,673720360,673720360,673720360,
     a 589568797,673717006,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=211,220)/
     1 353508125,673720360,673720360,673720360,673720360,673720360,
     2 504503069,673720360,673720360,673720360,673720360,673720360,
     3 236528157,673720360,673720360,673720360,673720360,673720360,
     4 386538269,673713180,673720360,673720360,673720360,673720360,
     5 554833694,673720360,673720360,673720360,673720360,673720360,
     6 453909534,673720360,673720360,673720360,673720360,673720360,
     7 454891038,673713678,673720360,673720360,673720360,673720360,
     8 454891038,671157774,673720360,673720360,673720360,673720360,
     9 387648031,673720360,673720360,673720360,673720360,673720360,
     a 453906720,673720334,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=221,230)/
     1 453906720,672928270,673720360,673720360,673720360,673720360,
     2 487725856,673720331,673720360,673720360,673720360,673720360,
     3 487725856,673720334,673720360,673720360,673720360,673720360,
     4 286008353,236722200,673720360,673720360,673720360,673720360,
     5 302851105,270013706,673720360,673720360,673720360,673720360,
     6 219554849,404032018,673720336,673720360,673720360,673720360,
     7 236332065,269098012,673720334,673720360,673720360,673720360,
     8 203098657,673720360,673720360,673720360,673720360,673720360,
     9 203098657,673720348,673720360,673720360,673720360,673720360,
     a 454756897,672931864,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=231,240)/
     1 304155169,673720348,673720360,673720360,673720360,673720360,
     2 168889377,672010263,673720360,673720360,673720360,673720360,
     3 236260385,673720330,673720360,673720360,673720360,673720360,
     4 236260385,673717002,673720360,673720360,673720360,673720360,
     5 303369249,673715212,673720360,673720360,673720360,673720360,
     6 219614753,673720360,673720360,673720360,673720360,673720360,
     7 453644065,673720332,673720360,673720360,673720360,673720360,
     8 404295457,673718805,673720360,673720360,673720360,673720360,
     9 404295457,672932373,673720360,673720360,673720360,673720360,
     a 236654369,673717516,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=241,250)/
     1 487460897,673720360,673720360,673720360,673720360,673720360,
     2 487460897,672205838,673720360,673720360,673720360,673720360,
     3 487460897,471734294,673720334,673720360,673720360,673720360,
     4 303501857,673720349,673720360,673720360,673720360,673720360,
     5 403641633,673717527,673720360,673720360,673720360,673720360,
     6 371070753,673720331,673720360,673720360,673720360,673720360,
     7 503978273,673713692,673720360,673720360,673720360,673720360,
     8 353900833,673720354,673720360,673720360,673720360,673720360,
     9 353900833,673717282,673720360,673720360,673720360,673720360,
     a 202251041,673720349,673720360,673720360,673720360,673720360/
      data ((funn(i,j),i=1,nsiz),j=251,258)/
     1 202251041,673717277,673720360,673720360,673720360,673720360,
     2 269360161,673720348,673720360,673720360,673720360,673720360,
     3 353246241,672992270,673720360,673720360,673720360,673720360,
     4 487463969,673720360,673720360,673720360,673720360,673720360,
     5 487463969,672205838,673720360,673720360,673720360,673720360,
     6 454892577,672143122,673720360,673720360,673720360,673720360,
     7 454892577,353376018,673720360,673720360,673720360,673720360,
     8 420093217,673720334,673720360,673720360,673720360,673720360/
      data ((funm(i,j),i=1,nsiz),j=  1, 10)/
     1 386931466,673720360,673720360,673720360,673720360,673720360,
     2 420878348,673720360,673720360,673720360,673720360,673720360,
     3 252644877,673720360,673720360,673720360,673720360,673720360,
     4 453644813,673720354,673720360,673720360,673720360,673720360,
     5 421270029,673720360,673720360,673720360,673720360,673720360,
     6 488183310,454892578,673720360,673720360,673720360,673720360,
     7 203102990,286006538,673720360,673720360,673720360,673720360,
     8 203102990,453643797,673720360,673720360,673720360,673720360,
     9 404429582,673720347,673720360,673720360,673720360,673720360,
     a 202252558,673720360,673720360,673720360,673720360,673720360/
      data ((funm(i,j),i=1,nsiz),j= 11, 20)/
     1 202252558,672865564,673720360,673720360,673720360,673720360,
     2 470950158,673717277,673720360,673720360,673720360,673720360,
     3 672014862,673720360,673720360,673720360,673720360,673720360,
     4 236261903,673720360,673720360,673720360,673720360,673720360,
     5 370874383,673717514,673720360,673720360,673720360,673720360,
     6 488314895,673720360,673720360,673720360,673720360,673720360,
     7 236785168,673718039,673720360,673720360,673720360,673720360,
     8 253562384,673720360,673720360,673720360,673720360,673720360,
     9 421334544,673713426,673720360,673720360,673720360,673720360,
     a 488380433,673720360,673720360,673720360,673720360,673720360/
      data ((funm(i,j),i=1,nsiz),j= 21, 30)/
     1 168955154,672143381,673720360,673720360,673720360,673720360,
     2 453909522,672864283,673720360,673720360,673720360,673720360,
     3 269946389,673714461,673720360,673720360,673720360,673720360,
     4 671814165,673720360,673720360,673720360,673720360,673720360,
     5 236392981,673720348,673720360,673720360,673720360,673720360,
     6 337056277,673720360,673720360,673720360,673720360,673720360,
     7 488378901,673720360,673720360,673720360,673720360,673720360,
     8 218765333,673720360,673720360,673720360,673720360,673720360,
     9 235739158,673720360,673720360,673720360,673720360,673720360,
     a 488311321,673720360,673720360,673720360,673720360,673720360/
      data ((funm(i,j),i=1,nsiz),j= 31, 40)/
     1 571807769,673720360,673720360,673720360,673720360,673720360,
     2 219028249,673713934,673720360,673720360,673720360,673720360,
     3 387062553,673720349,673720360,673720360,673720360,673720360,
     4 218762779,673720360,673720360,673720360,673720360,673720360,
     5 218762779,673720331,673720360,673720360,673720360,673720360,
     6 505155099,673713686,673720360,673720360,673720360,673720360,
     7 505220635,673715995,673720360,673720360,673720360,673720360,
     8 236915228,673720360,673720360,673720360,673720360,673720360,
     9 387451932,488312351,673720360,673720360,673720360,673720360,
     a 303766812,673714199,673720360,673720360,673720360,673720360/
      data ((funm(i,j),i=1,nsiz),j= 41, 49)/
     1 554833694,673720360,673720360,673720360,673720360,673720360,
     2 453909534,673720360,673720360,673720360,673720360,673720360,
     3 387648031,673720360,673720360,673720360,673720360,673720360,
     4 487725856,673720331,673720360,673720360,673720360,673720360,
     5 487725856,673720334,673720360,673720360,673720360,673720360,
     6 286008353,236722200,673720360,673720360,673720360,673720360,
     7 302851105,270013706,673720360,673720360,673720360,673720360,
     8 219554849,404032018,673720336,673720360,673720360,673720360,
     9 236332065,269098012,673720334,673720360,673720360,673720360/
      data (funp(j),j=  1, 10)/
     1      601    ,
     2     2201    ,
     3     1806    ,
     4     1305    ,
     5     2001    ,
     6      625    ,
     7     1517    ,
     8      206    ,
     9      204    ,
     a     1613    /
      data (funp(j),j= 11, 20)/
     1     1205    ,
     2     1538    ,
     3      701    ,
     4      106    ,
     5     1320    ,
     6     1604    ,
     7     1306    ,
     8      303    ,
     9      604    ,
     a      702    /
      data (funp(j),j= 21, 30)/
     1     1001    ,
     2     2104    ,
     3     1804    ,
     4      624    ,
     5      631    ,
     6     1505    ,
     7     1511    ,
     8     1512    ,
     9     1513    ,
     a     1518    /
      data (funp(j),j= 31, 40)/
     1     1519    ,
     2     1520    ,
     3     1528    ,
     4     2602    ,
     5     1301    ,
     6      511    ,
     7     1603    ,
     8     1324    ,
     9     1807    ,
     a      102    /
      data (funp(j),j= 41, 50)/
     1      610    ,
     2      506    ,
     3      518    ,
     4     1325    ,
     5      712    ,
     6     1526    ,
     7     1530    ,
     8     1534    ,
     9     2105    ,
     a      803    /
      data (funp(j),j= 51, 60)/
     1     1315    ,
     2     1316    ,
     3     1310    ,
     4      504    ,
     5      517    ,
     6     1314    ,
     7      626    ,
     8      613    ,
     9     1514    ,
     a     1541    /
      data (funp(j),j= 61, 70)/
     1      744    ,
     2     1204    ,
     3     1802    ,
     4      513    ,
     5     2301    ,
     6     1312    ,
     7     1307    ,
     8     1004    ,
     9     1104    ,
     a      804    /
      data (funp(j),j= 71, 80)/
     1     1321    ,
     2     2703    ,
     3     1524    ,
     4     1527    ,
     5      743    ,
     6      520    ,
     7      503    ,
     8      519    ,
     9      711    ,
     a      801    /
      data (funp(j),j= 81, 90)/
     1      802    ,
     2     1330    ,
     3      201    ,
     4      514    ,
     5     2506    ,
     6      603    ,
     7     2601    ,
     8      606    ,
     9     1902    ,
     a     1203    /
      data (funp(j),j= 91,100)/
     1      101    ,
     2     1317    ,
     3     1501    ,
     4     1535    ,
     5     1525    ,
     6      619    ,
     7     1537    ,
     8     2003    ,
     9     2204    ,
     a     2101    /
      data (funp(j),j=101,110)/
     1      505    ,
     2     1304    ,
     3     1313    ,
     4     1701    ,
     5      501    ,
     6      628    ,
     7     1005    ,
     8      104    ,
     9      110    ,
     a      108    /
      data (funp(j),j=111,120)/
     1      109    ,
     2      901    ,
     3     2704    ,
     4     2705    ,
     5     2706    ,
     6     2707    ,
     7     1504    ,
     8     1516    ,
     9     1326    ,
     a     1322    /
      data (funp(j),j=121,130)/
     1      622    ,
     2      616    ,
     3      616    ,
     4      617    ,
     5      617    ,
     6     1308    ,
     7     2203    ,
     8     1536    ,
     9     1539    ,
     a     1540    /
      data (funp(j),j=131,140)/
     1     1542    ,
     2     1319    ,
     3      304    ,
     4     1330    ,
     5     2709    ,
     6     1502    ,
     7     1503    ,
     8     1509    ,
     9     1201    ,
     a      615    /
      data (funp(j),j=141,150)/
     1     1101    ,
     2      703    ,
     3     2102    ,
     4      302    ,
     5      706    ,
     6      707    ,
     7      708    ,
     8      709    ,
     9      710    ,
     a      704    /
      data (funp(j),j=151,160)/
     1      705    ,
     2     1601    ,
     3     1002    ,
     4     1606    ,
     5     1318    ,
     6      509    ,
     7      609    ,
     8     1508    ,
     9     1510    ,
     a     1515    /
      data (funp(j),j=161,170)/
     1     1523    ,
     2     1531    ,
     3     1102    ,
     4      401    ,
     5      614    ,
     6      305    ,
     7      103    ,
     8     2205    ,
     9      502    ,
     a      515    /
      data (funp(j),j=171,180)/
     1      602    ,
     2     1808    ,
     3     2002    ,
     4     1311    ,
     5     1311    ,
     6      903    ,
     7     1602    ,
     8      605    ,
     9     1805    ,
     a      107    /
      data (funp(j),j=181,190)/
     1     1006    ,
     2      507    ,
     3      202    ,
     4     2505    ,
     5     1323    ,
     6     1614    ,
     7      630    ,
     8     1607    ,
     9      623    ,
     a      607    /
      data (funp(j),j=191,200)/
     1      618    ,
     2      203    ,
     3     1901    ,
     4      627    ,
     5     2103    ,
     6     2202    ,
     7      608    ,
     8      306    ,
     9      301    ,
     a      902    /
      data (funp(j),j=201,210)/
     1     1809    ,
     2     2701    ,
     3     2702    ,
     4     1103    ,
     5     1506    ,
     6     1507    ,
     7     1521    ,
     8     1522    ,
     9     1329    ,
     a     1003    /
      data (funp(j),j=211,220)/
     1      612    ,
     2      611    ,
     3     1309    ,
     4     1529    ,
     5      514    ,
     6     1401    ,
     7     1532    ,
     8     1533    ,
     9     1616    ,
     a     1328    /
      data (funp(j),j=221,230)/
     1     1327    ,
     2      516    ,
     3      508    ,
     4     2503    ,
     5     2501    ,
     6     2504    ,
     7     2502    ,
     8      714    ,
     9      715    ,
     a      717    /
      data (funp(j),j=231,240)/
     1      719    ,
     2      720    ,
     3      721    ,
     4      724    ,
     5      725    ,
     6      726    ,
     7      713    ,
     8      727    ,
     9      728    ,
     a      723    /
      data (funp(j),j=241,250)/
     1      729    ,
     2      742    ,
     3      745    ,
     4      730    ,
     5      731    ,
     6      732    ,
     7      733    ,
     8      734    ,
     9      735    ,
     a      722    /
      data (funp(j),j=251,258)/
     1      716    ,
     2      718    ,
     3      736    ,
     4      737    ,
     5      741    ,
     6      738    ,
     7      739    ,
     8      740    /
      data point/  1,  8, 13, 34, 49, 61, 75, 82, 85, 95, 96, 98,119,
     1           132,139,142,163,165,182,209,215,219,220,224,259,259,
     2           259/
c+
      if(job.eq.0) then
c----------------------
c     display functions
c----------------------
c     display functions
         call basout(io,wte,'System functions:')
         call prntid(funm,funl1,wte)
      elseif(job.eq.1) then
c-------------------------------------------
c     recherche du pointeur associe a un nom
c-------------------------------------------
         k=(id(1)+128)/256
         if(k.lt.0) k=k-1
         ip=abs(id(1)-256*k)-9
c        ip=mod(id(1),256)-9
         if(ip.le.26) then
            do 10 k = point(ip) , point(ip+1)-1
               if (eqid(id,funn(1,k))) then
                  fptr=funp(k)
                  return
               endif
 10         continue
            fptr=0
            return
         else
            fptr=-1
            return
         endif
      elseif(job.eq.2) then
c-------------------------------------------
c     recherche du nom associe a un pointeur
c-------------------------------------------
         id(1)=0
         do 20 i=1,funl
            if (funp(i).eq.fptr) then
               call putid(id,funn(1,i))
               return
            endif
 20      continue
      elseif(job.eq.3) then
c-------------------------
c     ajout d'une fonction
c-------------------------
         k=(id(1)+128)/256
         if(k.lt.0) k=k-1
         ip=abs(id(1)-256*k)-9
c         ip=mod(id(1),256)-9
         if(ip.gt.26) then
            call error(36)
            return
         endif
         if(funl.ge.mxf) then
            err=mxf
            call error(107)
            return
         endif
         do 30 k = point(ip) , point(ip+1)-1
            if (eqid(id,funn(1,k))) then
               call error(106)
               return
            endif
 30      continue
         ipp=point(ip+1)
         call icopy(point(27)-ipp,funp(ipp),-1,funp(ipp+1),-1)
         funp(ipp)=fptr
         do 31 i=1,nsiz
            call icopy(point(27)-ipp,funn(i,ipp),-nsiz,
     $           funn(i,ipp+1),-nsiz)
 31      continue
         call putid(funn(1,ipp),id)
c     mise a jour de la table des pointeurs
         do 32 i=ip+1,27
            point(i)=point(i)+1
 32      continue
         funl=funl+1
      elseif(job.eq.4) then
c-------------------------------
c     suppression d'une fonction
c-------------------------------
         k=(id(1)+128)/256
         if(k.lt.0) k=k-1
         ip=abs(id(1)-256*k)-9
c         ip=mod(id(1),256)-9
         if(ip.le.26) then
            do 42 k = point(ip) , point(ip+1)-1
               if (eqid(id,funn(1,k))) then
                  fptr=funp(k)
                  call icopy(point(27)-k-1,funp(k+1),1,funp(k),1)
                  do 40 i=1,nsiz
                     call icopy(point(27)-k-1,funn(i,k+1),nsiz,
     $                    funn(i,k),nsiz)
 40               continue
c     mise a jour de la table des pointeurs
                  do 41 i=ip+1,27
                     point(i)=point(i)-1
 41               continue
                  funl=funl-1
                  return
               endif
 42         continue
            fptr=0
            return
         else
            fptr=-1
            return
         endif
      endif
c
      return
      end
