#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

#include "comdef.H"

Colormap cmap;
Cursor cursor;
Display *disp;
Font font;
GC gc, pmgc;
KeySym key;
Pixmap pixmap;
Window window;
XColor black, red, exact;
XSizeHints hint;
XWMHints wmhints;
XSetWindowAttributes setwinattr;
int width, height;
int screen, depth, len;
char text[30];
unsigned long fg, bg;

unsigned long pixels[500], event_mask;
int scale_xy, status, getmaxx, getmaxy;
long planes[1];
XColor MyPalette[NCOLORS];
int i;
struct  TColor {
  unsigned int r, g, b;
};

extern struct TColor Palette[256];

void InitGraph()
{
  disp = XOpenDisplay(0);
  if (disp == (Display *) NULL) {
    fprintf(stderr, "Could not open display\n");
    exit(1);
  }
  screen = DefaultScreen(disp);
  fg = WhitePixel(disp, screen);
  bg = BlackPixel(disp, screen);

  cmap = XDefaultColormap(disp, screen);
  XAllocColorCells(disp, cmap, 0, planes, 0, pixels, NCOLORS+10);
  XStoreNamedColor(disp, cmap, "black", pixels[0], DoRed | DoGreen | DoBlue);
  XStoreNamedColor(disp, cmap, "white", pixels[1], DoRed | DoGreen | DoBlue);
  XStoreNamedColor(disp, cmap, "cadet blue", pixels[2], DoRed | DoGreen | DoBlue);
  XStoreNamedColor(disp, cmap, "grey", pixels[3], DoRed | DoGreen | DoBlue);
  XStoreNamedColor(disp, cmap, "dark green", pixels[4], DoRed | DoGreen | DoBlue);

  for(i=0; i<NCOLORS; i++) {
    MyPalette[i].pixel=pixels[10+i];
    MyPalette[i].red=Palette[16+i].r*1022;
    MyPalette[i].green=Palette[16+i].g*1022;
    MyPalette[i].blue=Palette[16+i].b*1022;
    MyPalette[i].flags = DoRed | DoGreen | DoBlue;
  }
  XStoreColors(disp, cmap, MyPalette, NCOLORS);

  hint.x = 30; hint.y = 1; getmaxx=hint.width = MAXX; getmaxy=hint.height = MAXY;
  hint.flags = PPosition | PSize;
  width = hint.width; height = hint.height;
  depth = DefaultDepth (disp, screen);
  window = XCreateSimpleWindow (disp, DefaultRootWindow(disp),
           hint.x, hint.y, hint.width, hint.height, 5, fg, bg);
  setwinattr.backing_store=Always;
  XChangeWindowAttributes(disp, window, CWBackingStore, &setwinattr);
  pixmap = XCreatePixmap (disp, window, width, height, depth);
  XSetStandardProperties (disp, window, "G.O.D.", "G.O.D.", None, 
                          NULL, 0, &hint);
  gc = XCreateGC (disp, window, 0, 0);
  XSetGraphicsExposures(disp, gc, 0);     /* IMPORTANT!  If you do not
                specifically ask not to get Expose events, every XCopyArea
                will generate one, & the event queue will fill up.      */
  XSetBackground (disp, gc, bg);
  XSetForeground (disp, gc, fg);
  wmhints.flags = InputHint;
  wmhints.input = True;
  XSetWMHints(disp, window, &wmhints);    /* Thanks to Doug Merritt */
  event_mask=ButtonPressMask | ButtonReleaseMask | ButtonMotionMask | 
             ExposureMask| KeyPressMask | KeyReleaseMask |
             StructureNotifyMask | PointerMotionMask;
  XSelectInput (disp, window, event_mask);
  XMapRaised (disp, window);
  XSync(disp, 1);
  sleep(1);
}

