.\"
.\" Copyright (c) 1994 David I. Bell and Landon Curt Noll
.\" Permission is granted to use, distribute, or modify this source,
.\" provided that this copyright notice remains intact.
.\"
.\" calculator by David I. Bell
.\" man page by Landon Noll
.TH calc 1 "^..^" "15nov93"
.SH NAME
\f4calc\f1 \- arbitrary precision calculator
.SH SYNOPSIS
\f4calc\fP
[
\f4\-h\fP
] [
\f4\-q\fP
] [
.I calc_cmd
\&.\|.\|.
]
.SH DESCRIPTION
\&
.br
CALC COMMAND LINE
.PP
.TP
\f4 \-h\f1
Print a help message.
This option implies \f4 \-q\f1.
This is equivalent to the calc command \f4help help\fP.
.TP
\f4 \-q\f1
Disable the use of the \f4$CALCRC\f1 startup library scripts.
.PP
Without \f4calc_cmd\fPs, \f4calc\fP operates interactively.
If one or more \f4calc_cmd\fPs are given on the command line,
\f4calc\fP will execute them and exit.
.PP
Normally on startup, \f4calc\fP attempts to execute a collection 
of library scripts.
The environment variable \f4$CALCRC\f1 (if non-existent then
a compiled in value) contains a \f4:\fP separated list of
startup library scripts.
No error conditions are produced if these startup library scripts
are not found.
.PP
Filenames are subject to ``~'' expansion (see below).
The environment variable \f4$CALCPATH\fP (if non-existent then
a compiled in value) contains a \f4:\fP separated list of search
directories.
If a file does not begin with \f4/\fP, \f4~\fP or \f4./\fP,
then it is searched for under each directory listed in the \f4$CALCPATH\fP.
It is an error if no such readable file is found.
.PP
For more information use the following calc commands:
.PP
.in 1.0i
help usage
.br
help help
.br
help environment
.in -1.0i
.PP
OVERVIEW
.PP
\f4Calc\fP is arbitrary precision arithmetic system that uses 
a C-like language.
\f4Calc\fP is useful as a calculator, an algorithm prototyped
and as a mathematical research tool.
More importantly, \f4calc\fP provides one with a machine
independent means of computation.
.PP
\f4Calc\fP comes with a rich set of builtin mathematical 
and programmatic functions.
.PP
\f4Calc\fP is distributed with library of scripts.
Written in the same C-like language, library scripts may be
read in and executed during a \f4calc\fP session.
These library scripts are also provided because they are
useful and to serve as examples of the \f4calc\fP language.
One may further extend \f4calc\fP thru the
use of user defined scripts.
.PP
Internally calc represents numeric values as fractions reduced to their
lowest terms.
The numerators and denominators of these factions may grow to
arbitrarily large values.
Numeric values read in are automatically converted into rationals.
The user need not be aware of this internal representation.
.PP
For more information use the following calc commands:
.PP
.in 1.0i
help intro
.br
help builtin
.br
help stdlib
.br
help define
.br
show builtins
.br
show functions
.in -1.0i
.PP
DATA TYPES
.PP
Fundamental builtin data types include integers, real numbers, 
rational numbers, complex numbers and strings.
.PP
By use of an object, one may define an arbitrarily complex
data types.
One may define how such objects behave a wide range of
operations such as addition, subtraction,
multiplication, division, negation, squaring, modulus,
rounding, exponentiation, equality, comparison, printing
and so on.
.PP
For more information use the following calc commands:
.PP
.in 1.0i
help types
.br
help obj
.br
show objfuncs
.in -1.0i
.PP
VARIABLES
.PP
Variables in \f4calc\fP are typeless.
In other words, the fundamental type of a variable is determined by its content.
Before a variable is assigned a value it has the value of zero.
.PP
The scope of a variable may be global, local to a file, or local to a
procedure.
Values may be grouped together in a matrix, or into a
a list that permits stack and queue style operations.
.PP
For more information use the following calc commands:
.PP
.in 1.0i
help variable
.br
help mat
.br
help list
.br
show globals
.in -1.0i
.PP
INPUT/OUTPUT
.PP
A leading ``0x'' implies a hexadecimal value,
a leading ``0b'' implies a binary value,
and a ``0'' followed by a digit implies an octal value.
Complex numbers are indicated by a trailing ``i'' such as in ``3+4i''.
Strings may be delimited by either a pair of single or double quotes.
By default, \f4calc\fP prints values as if they were floating point numbers.
One may change the default to print values in a number of modes
including fractions, integers and exponentials.
.PP
A number of stdio-like file I/O operations are provided.
One may open, read, write, seek and close files.
Filenames are subject to ``\~'' expansion to home directories
in a way similar to that of the Korn or C-Shell.
.PP
For example:
.PP
.in 1.0i
~/.calcrc
.br
~chongo/lib/fft_multiply.cal
.in -1.0i
.PP
For more information use the following calc command:
.PP
.in 1.0i
help file
.in -1.0i
.PP
CALC LANGUAGE
.PP
The \f4calc\fP language is a C-like language.
The language includes commands such as variable declarations, 
expressions, tests, labels, loops, file operations, function calls.
These commands are very similar to their counterparts in C.
.PP
The language also include a number of commands particular
to \f4calc\fP itself.
These include commands such as function definition, help, 
reading in library scripts, dump files to a file, error notification, 
configuration control and status.
.PP
For more information use the following calc command:
.PP
.in 1.0i
help command
.br
help statement
.br
help expression
.br
help operator
.br
help config
.in -1.0i
.PP
.SH FILES
\&
.br
.PD 0
.TP 20
${LIBDIR}/*.cal
library scripts shipped with calc
.br
.sp
.TP 20
${LIBDIR}/help/*
help files
.br
.sp
.TP 20
${LIBDIR}/bindings
command line editor bindings
.sp
.SH ENVIRONMENT
\&
.br
.PD 0
.TP 5
CALCPATH
A :-separated list of directories used to search for
scripts filenames that do not begin with /, ./ or ~.
.br
.sp
Default value: .:./lib:~/lib:${LIBDIR}
.br
.sp
.TP 5
CALCRC
On startup (unless \-h or \-q was given on the command
line), calc searches for files along this :-separated
environment variable.
.br
.sp
Default value: ${LIBDIR}/startup:~/.calcrc
.br
.sp
.TP 5
CALCBINDINGS
On startup (unless \-h or \-q was given on the command
line), calc reads key bindings from the filename specified
by this environment variable.
.br
.sp
Default value: ${LIBDIR}/bindings
.sp
.SH CREDIT
\&
.br
Written by David I. Bell.
.sp
Thanks for suggestions and encouragement from Peter Miller,
Neil Justusson, and Landon Noll.
.sp
Portions of this program are derived from an earlier set of
public domain arbitrarily precision routines which was posted
to the net around 1984.  By now, there is almost no recognizable 
code left from that original source.
.sp
Most of this source and binary is:
.sp
.PP
.in 1.0i
Copyright (c) 1994 David I. Bell
.sp
.in -1.0i
.PP
Some files are a copyrighted David I. Bell and Landon Noll.
.sp
Permission is granted to use, distribute, or modify this source,
provided that this copyright notice remains intact.
.sp
Send calc comments, suggestions, bug fixes, enhancements
and interesting calc scripts that you would like you see included 
in future distributions to:
.sp
.PP
.in 1.0i
dbell@canb.auug.org.au
.br
chongo@toad.com
.sp
.in -1.0i
.PP
.sp
Enjoy!
