# $Date: 1994/11/07 10:54:13 $ $Author: andi $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
p_stmtseq  - Parserfunction for statment sequences

p_stmtseq( cat_, father_ )

cat_        - Object to analyse
father_     - Attribute given from the father_

This is the parser-function for objects of the type  "_stmtseq". The
expression will be analysed to find its specific parser-function. If
there's no parser-function defined, mmc::pGENERIC will be called.

++#

mmc::p_stmtseq := proc( cat_, father_ )
local	aloc_, ason_, check_, depth, i_, tv_;
begin
	if( father_["@TEMP"]["HOLD"] = TRUE ) then
		return( M2C_generic( cat_, father_ ) );
	end_if;

	aloc_:= mmc::acopy( father_ ); 
	tv_  := mmc::tvnew( aloc_ );    
	
	if( mmc::depth = 1 ) then mmc::stmt:= mmc::stmt +1; end_if;
	depth:= mmc::depth;
	
	#++ Analyse the first (n-1) statements ++++++++++++++++++++++++++++++++#

	for i_ from 1 to nops(cat_)-1 do

		ason_:= mmc::acopy( aloc_ ); 
		ason_["@TEMP"]["NOCOPY"]:= TRUE;

		if( mmc::depth = 1 ) then mmc::depth:= 0;     end_if;
		ason_:= mmc::pPARSER( op(cat_,i_), ason_ ); 
		if( mmc::depth = 0 ) then mmc::depth:= depth; end_if;

		mmc::amerge( aloc_, ason_ );
		
			#++ No C-code, if CHECK is active +++++++++++++++++++++#
			
		if( father_["@DOWN"]["CHECK"] <> TRUE ) then 
			mmc::cl( mmc::c, tv_." = ".ason_["@TEMP"]["CODE"].";" );
			if( ason_["@TEMP"]["NOCOPY"] <> TRUE ) then
				mmc::cl( mmc::c, "MMMfree( ".tv_." );" );
			end_if;
			mmc::cl( mmc::c, "" );
		end_if;
		
		if( mmc::depth = 1 ) then mmc::stmt:= mmc::stmt+1; end_if;
	end_for;
	
	### Analyse the last statement of the sequence ++++++++++++++++++++++++#
	
	ason_:= mmc::acopy( aloc_ );
	ason_["@TEMP"]:= father_["@TEMP"];             
	
	if( mmc::depth = 1 ) then mmc::depth:= 0;     end_if;
	ason_:= mmc::pPARSER( op(cat_,i_+1), ason_ ); 
	if( mmc::depth = 0 ) then mmc::depth:= depth; end_if;
	
	mmc::amerge( aloc_, ason_ );
	
	aloc_["@TEMP"]:= ason_["@TEMP"];       #++ Last son will be returned ++#
	
	mmc::tvnew( aloc_ );

	return( aloc_ );
end_proc:

_stmtseq:= funcattr( _stmtseq, mmc::pname, mmc::p_stmtseq ):


