# $Date: 1994/06/06 09:45:58 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
pGENERIC  - The given object will be handled as an "generic"

pGENERIC( gen_, father_ )

gen_        - Object to analyse
father_     - Attribute given from the father_

"gen_" will be handled as a 'generic' and written as a MuPAD-object.  On
runtime the MuPAD-kernel evaluates it and returns a copy. Evaluation can
be suppressed by the option "HOLD". If "NOCOPY" is set, mmc tries to re-
turn the not-copied S_Pointer. Only if this is possible, pGENERIC return
the attribute "NOCOPY".
++#

mmc::pGENERIC:= proc( gen_, father_ )
local	aloc_, copy_, eval_, gidx_, gtxt_;
begin
	if( args(0) > 2 ) then                      #++ sequence was flatted ++#
		father_:= args( args(0) );
		gen_   := subsop( op(args(),1..args(0)-1), 
				  0=MMC_HOLD_OBJ(_exprseq) );
	end_if;

	if( val(gen_) = hold(cat_) ) then                  #++ NIL was given ++#
		gen_:= hold(hold(NIL));
	end_if;
	
	#++ Initialize local parser-attributes ++++++++++++++++++++++++++++++++#
	
	aloc_:= mmc::acopy( father_ );
	aloc_["@TEMP"]["GENERIC"]:= TRUE;
	
	if( father_["@TEMP"]["HOLD"] = TRUE ) then
		aloc_["@TEMP"]["TYPE" ] := domtype( gen_ );
		aloc_["@TEMP"]["VALUE"] := gen_;
	end_if;
	
	#++ Analyse the attributes given by the father ++++++++++++++++++++++++#
	
	if  ( (eval_:= father_["@TEMP"]["HOLD"]  <> TRUE) ) then 
		copy_:= "0L";
	elif(          father_["@TEMP"]["NOCOPY"] = TRUE  ) then 
		copy_:= "0L";	 aloc_["@TEMP"]["NOCOPY"]:= TRUE;
	else 	
		copy_:= "1L";
	end_if;
	
	if( father_["@DOWN"]["CHECK"] = TRUE ) then return( aloc_ ); 
	end_if;

	#++ Generate "generic" and its return-Code ++++++++++++++++++++++++++++#
	
	gtxt_:= "(".expr2text( gen_ ).")";
	
	if( (gidx_:= contains(aloc_["@FLOW"]["GENVAL"],gtxt_)) = 0 ) then
		mmc::cl( mmc::g, ", ".gtxt_." " );
		
		aloc_["@FLOW"]["GENVAL"]:= aloc_["@FLOW"]["GENVAL"].[gtxt_];
		gidx_:= (aloc_["@FLOW"]["GENNUM"]:= aloc_["@FLOW"]["GENNUM"]+1);
	end_if;

	aloc_["@TEMP"]["CODE"]:= "MDM_get_generic(exec,".gidx_."L,".copy_.")";
	
	if( eval_ ) then 	
		aloc_["@TEMP"]["CODE"]:= "MEV_eval(".
			aloc_["@TEMP"]["CODE"].",MEVC_UNKNOWN,MEVC_EVAL)"
		;
	end_if;
	
	aloc_ ;
end_proc:

# end of file #
