# $Date: 1994/11/07 10:54:11 $ $Author: andi $ $Revision: 1.2 $ #

# andi, 07/11/94 #

#++
pEXPR  - Parser-entry for MuPAD-expressions

pEXPR( cat_, father_ )

cat_        - Object to analyse
father_     - Attribute given from the father_

This is the parser-function for all objects of the type DOM_EXPR. The
expression will be analysed to find its specific parser-function.  If
there's no parser-function defined, mmc::pGENERIC will be called.

++#

DOM_EXPR::parser := (
 
mmc::pEXPR:= proc( cat_, father_ )

local	OK_, aloc_, ason_, check_, expr, fcall_, feval_, fname_, pfunc_, i, tab, tv1, tv2, tv3;

begin
	if( args(0) > 2 ) then                    #++ sequence was flatted ! ++#
		cat_   := op( args(), 1..args(0)-1 );
		father_:= args(args(0));
	end_if;	
	check_:= bool( father_["@DOWN"]["CHECK"] = TRUE );

	if( father_["@TEMP"]["HOLD"] = TRUE ) then
		return( mmc::pGENERIC( cat_, father_ ) );
	end_if;

	#++ The 0th operand describes the type of the function-call +++++++++++#

	fcall_  := op( cat_,0 );
	fname_  := "";
	feval_  := "MEV_eval_expr";                   #++ MuPAD-kernel-entry ++#

	aloc_   := mmc::acopy( father_ );
	OK_     := FAIL;
	
	#++ Extract INLINE C-Kode +++++++++++++++++++++++++++++++++++++++++++++#

	if( fcall_ = hold(INLINE_C) ) then
		OK_:= "READY";
		if( nops(cat_) <> 1 or domtype(op(cat_,1)) <> DOM_STRING ) then
			mmc::error( "Bad use if INLINE_C" );
			aloc_["@TEMP"]["CODE"]:= "(INLINE_C_RESULT = MMMNULL)";
		else
			mmc::cl( mmc::c,"{ /*** Begin Of Inline Kode ***/\n" );
			mmc::cpush( mmc::c );		
			mmc::cl( mmc::c, op(cat_,1) );
			mmc::cpop( mmc::c );		
			mmc::cl( mmc::c,"} /*** End Of Inline Kode ***/\n" );
			tv1 := mmc::tvnew( aloc_ );
			tv2 := mmc::tvnew( aloc_ );
			mmc::cl( mmc::c,
				tv1." = MTR_set_string( MF_STORAGE_TYPE, \"INLINE_C_RESULT\" );",
				tv2." = MST_read_ident(".tv1.",MEVC_EVAL,MSTC_option_standard,&info,&stamp,&procdepth);",
				"if( ".tv2." != MMMNULL ) { MMMfree( ".tv2." ); }",
				"MST_write_ident(".tv1.",INLINE_C_RESULT,MSTC_option_standard,&info,&stamp,&procdepth);",
        			"MEV_refresh_ass_mem(MEVC_refreshoption_assign, info, stamp, procdepth);"
			);
			mmc::tvdel( aloc_ );
			mmc::tvdel( aloc_ );
			aloc_["@TEMP"]["CODE"]:= "INLINE_C_RESULT";
		end_if;
	end_if;
		
		#++ fcall_ = DOM_IDENT ++++++++++++++++++++++++++++++++++++++++#
		
	if( OK_ = FAIL and domtype(fcall_) = DOM_IDENT ) then

		fname_:= expr2text( fcall_ );

			#++ Check for later binding +++++++++++++++++++++++++++#
			
		if( contains(father_["@DOWN"]["FLAGS"],"LATER_BINDING") ) then
		
			#++ ADD TABLE OF OBJECTS WITH LATER BINDING ??? !!! +++#
			
			#++ ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? 
			    'fcall_' generisch definieren. Der Bezeichner muss 
			    als nicht evaluierte Kopie erzeugt und in op[0] 
			    einer expression eingefuegt werden.
			++#
		 	OK_:= "UNEVAL_COPY";

		else	#++ Try to bind now +++++++++++++++++++++++++++++++++++#
			
			fcall_:= level( fcall_,99 );           #++ CAUTION ! ++#
			if( domtype(fcall_) = DOM_IDENT ) then
				mmc::warn( "Undefined function \"".fname_."\"".
				           "trying later-binding"
				);
			#++ ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? 
			    'fcall_' generisch definieren. Der Bezeichner muss 
			    als nicht evaluierte Kopie erzeugt und in op[0] 
			    einer expression eingefuegt werden.
			++#
		 		OK_:= "UNEVAL_COPY";
			end_if;			
		end_if;
	end_if;


		#++ fcall_ = DOM_PROC +++++++++++++++++++++++++++++++++++++++++#

	if( OK_ = FAIL and domtype(fcall_) = DOM_PROC ) then
						
			#++ Include as a 'generic' ++++++++++++++++++++++++++++#

		if( fname_ = "" or
		    contains(father_["@DOWN"]["FLAGS"], "PROC_GENERIC")
		  ) then

			#++ ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? 
			    'fcall_' generisch definieren. Die Prozedur muss 
			    als nicht evaluierte Kopie erzeugt und in op[0] 
			    einer expression eingefuegt werden.
			++#
			OK_:= "UNEVAL_COPY";

			#++ Use later-binding on the known procedure-name +++++#

		elif( contains(father_["@DOWN"]["FLAGS"], "LATER_BINDING") or
		      contains(father_["@DOWN"]["FLAGS"], "PROC_LATER_BINDING")
		    ) then
		  
			fcall_:= text2expr( fname_ );

			#++ ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? ??? 
			    'fcall_' generisch definieren. Der Bezeichner muss 
			    als nicht evaluierte Kopie erzeugt und in op[0] 
			    einer expression eingefuegt werden.
			++#
		 	OK_:= "UNEVAL_COPY";
		end_if;



		if( contains(mmc::objects, fname_) > 0 ) then    
				### ist/wird MF im aktuellen Modul ###
			fcall_   := FAIL;   ### EXEC+GENERICS werden erzeugt ! ###
			OK_:= "PROC_TO_LOCAL_MF";
		elif( contains(father_["@DOWN"]["FLAGS"], "PROC_INCLUDE") ) then
			if( not check_ ) then
				mmc::mesg( "Including procedure \"".fname_."\"" );
				mmc::objects := mmc::objects.[fname_];
				mmc::nobjects:= mmc::nobjects+1;
			end_if;
			fcall_   := FAIL;                        ### EXEC+GENERICS werden erzeugt ! ###
			OK_:= "PROC_TO_LOCAL_MF";
		elif( contains(father_["@DOWN"]["FLAGS"], "PROC_GENERIC") ) then
				OK_:= "PROC_GENERIC";
		else
			if( not check_ ) then
				mmc::warn( "Call of global MuPAD-procedure '".fname_."'" );
			end_if;
			OK_:= "LATER_BINDING";
			fcall_:=text2expr(fname_);
		end_if; 
	end_if;
	

		#++ fcall_ = DOM_DOMAIN (::parser undefined, see pPARSER) +++++#

	if( OK_ = FAIL and (pfunc_:=domattr(fcall_,"func_call")) <> FAIL ) then
		cat_ := subsop( cat_, 0=pfunc_ );
		ason_:= mmc::pEXPR( cat_, father_ );
		mmc::amerge( aloc_, ason_ );
		
OK_:= "CALL_PRIVATE";
	end_if;


		#++ Op[0] = DOM_FUNC_ENV :  privater Parser definiert ? +++++++#
		
	if( (OK_ = FAIL)  and  (domtype(fcall_) = DOM_FUNC_ENV)  ) then
	
			if( fname_ = "" ) then fname_:= op(fcall_,[1,3]);
			end_if;
			
			if( domtype((tab:=op(fcall_,3))) = DOM_TABLE ) then
				if( contains(tab,mmc::pname) ) then
					pfunc_  := tab[mmc::pname];
					OK_:= "CALL_PRIVATE";
				end_if;
			end_if;
			
			fcall_:= op( fcall_, 1 );               ### --> 1.EXEC ###
	end_if;
	
		# Op[0] = DOM_EXEC : System- oder (lokale(?) Modulfunktion ? #
		
	if( (OK_ = FAIL)  and  (domtype(fcall_) = DOM_EXEC) ) then

			if( fname_ = "" ) then fname_:= op(fcall_,3); end_if;
			
			# EXEC gehoert zu einer Modulfunktion  #

			if( mmc::isMF( fcall_ ) ) then
			
				if( op(fcall_,2) = mmc::modul ) then 
				    ### ist im aktuellen Modul ! ###
					
					fcall_:= FAIL;   
					### EXEC+GENERICS werden erzeugt ! ###

					if( contains(mmc::objects, fname_) > 0 ) then
						OK_:=  "EXEC_LOCAL_DEF_MF";
						feval_:= "MF_eval_".fname_;
					else
						OK_:=  "EXEC_LOCAL_UDEF_MF";
						feval_:= "MDM_eval_exec";
						if( not check_ ) then
							mmc::warn( 
							"Call to undefined local MF '".fname_."'"
							);
						end_if;
					end_if;
				else                     ### ist (hoffentlich) in externem Modul ###
					OK_:= "EXEC_NON_LOCAL_MF";
					feval_:= "MDM_eval_exec";    ### nicht naeher bekannt MF ###
				end_if;
			else
			
			### EXEC gehoert zu einer Systemfunktion ###################################
			
				OK_:= "EXEC_UNKNOWN_SF";
			end_if;
	end_if;
		
		### Op[0] = unbekanntes Objekt #####################################################
		
	if( (OK_ = FAIL) ) then
		OK_:= "OP_0_TO_GENERIC";
	end_if;
	
	### Protokoll, restliche Analyse und Kodegenerierung #######################################
		
		### fname_ darf keine ':' enthalten  #############################################
		
	if( strmatch( fname_, "\*:\*" ) ) then
		mmc::warn( "Bad name of identifier: '".fname_."'" );
	end_if;	
		
	if( mmc::loglevel > 0 ) then
		if( check_ ) then  str:= "??> ";
		             else  str:= ">>> ";  
		end_if;
		mmc::cl( mmc::l, 
			"[".mmc::stmt.":".mmc::depth."] ".str.OK_."( ".fname_." )"
		);
	end_if;


		### Reaktion auf den 0-ten Operanden ###
#
print( Unquoted, ">>> ACTION = ".OK_."( -".fname_."- ) ----" );
#
	case OK_ 
		
		of  "READY"		do
		break;
		of "CALL_PRIVATE"	do

			### Objekt an Parserf. 'pfunc_' weitergeben #

			aloc_:= pfunc_( cat_, father_ );
		break;

		of "EXEC_LOCAL_DEF_MF"	do
		of "EXEC_LOCAL_UDEF_MF"	do
		of "PROC_TO_LOCAL_MF"	do

			if( check_ ) then break;
			end_if;
			
			### Fuer MF die EXEC-Knoten mit ihren GENERICS bestimmen ###################
			
			if( contains(mmc::vobjects, fname_) ) then
				fcall_:= mmc::vobjects[fname_]["EXEC"];
			else	
				fcall_:= MMC_HOLD_OBJ(external)(fname_,mmc::modul);
				aloc_["@UP"]["@BOOL"]:= aloc_["@UP"]["@BOOL"] union {"PASS2"};
				mmc::mesg( "Second pass required" );
			end_if;
			
		### KEIN BREAK !!! ###
			
		of "OP_0_TO_GENERIC"	do
		of "PROC_GENERIC"	do
		of "LATER_BINDING"	do
		of "EXEC_UNKNOWN_SF"	do
		of "EXEC_NON_LOCAL_MF"	do

			if( check_ ) then break;
			end_if;
			
			### DOM_EXPR 'fcall_'(...) aufbauen und evaluieren  ###
			
			tv1 := mmc::tvnew( aloc_ );
			tv2 := mmc::tvnew( aloc_ );
			tv3 := mmc::tvnew( aloc_, "TVPC" );
			
				# 'fcall_'(NIL...NIL)  als generisches DOM_EXPR #

			expr:= subsop(	hold(hold)(NIL $ nops(cat_)), 
					0=fcall_, 
					Unsimplified 
			);
			ason_:= mmc::acopy( aloc_ );
			ason_["@TEMP"]["GENERIC"]:= TRUE;
			ason_["@TEMP"]["HOLD"]   := TRUE;
			ason_:= mmc::pGENERIC( expr, ason_ );
			mmc::amerge( aloc_, ason_ );

			mmc::cl( mmc::c,
				tv1." = ".ason_["@TEMP"]["CODE"].";",
				"MMMchange( &".tv1." );",
				tv3." = MMMP( &".tv1.", 1L, MMMwrite );",
				"MMMpoolinsert( &".tv3." );"
			);
			
				# NIL wird in DOM_EXPR durch Op[i] ersetzt #
			
			for i from 1 to nops(cat_) do
				if( op(cat_,i) = NIL ) then 
					mmc::cl( mmc::c, tv3."++;" );
					next;
				end_if;
				ason_:= mmc::acopy( aloc_ ); 
				
				# hold oder unten MEVC_NO_EVAL_ARGS_BIT ! ??? #
				ason_["@TEMP"]["HOLD"]:= TRUE; ### !!! ###	
						
				ason_:= mmc::pPARSER( op(cat_,i), ason_ );
				mmc::amerge( aloc_, ason_ );
				
				mmc::cl( mmc::c,	
					"MMMfree( *".tv3." );",
					"*".tv3."++ = ".
					ason_["@TEMP"]["CODE"].";"
				);
			end_for;
			
			mmc::cl( mmc::c,	
				"MMMinactiv( &".tv1." );",
				"MMMpooldelete( &".tv3." );"
			);

				### DOM_EXPR durch 'feval_' evaluieren ++#
			
				# EVALUIEREN feval_ !!!! 
				# 
			mmc::cl( mmc::c,	
				tv2." = MEV_eval_expr( ".tv1.", MEVC_UNKNOWN, ".
				"MEVC_EVAL );"  ### ??? ###
				# "MEVC_EVAL|MEVC_NO_EVAL_ARGS_BIT );"   ??? #
			);
			mmc::cl( mmc::c,	"MMMfree( ".tv1." );" );
			
			aloc_["@TEMP"]["CODE"]:= tv2;
			
			mmc::tvdel( aloc_, "TVPC" );
			mmc::tvdel( aloc_ );
			mmc::tvdel( aloc_ );
		break;
		
		otherwise                                  #++ NEVER REACHED ++#
			mmc::warn( "DOM_EXPR: trying to generate generic" );
			mmc::pGENERIC( cat_, father_ );
	end_case;

	if( mmc::loglevel > 0 ) then 
		mmc::cl( mmc::l, "[".mmc::stmt.":".mmc::depth."] <<< ".
			 OK_."( ".fname_." )" );
	end_if;

	aloc_["@DOWN"]:= father_["@DOWN"];         #++ Reinitalize "@DOWN" ! ++#
	aloc_ ;	
end_proc

):

# end of file #
