# $Date: 1994/06/06 09:45:55 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
mmg  - MuPAD-user-interface of the modul-generator

mmg( mname [, mmg_option] )

mname      - Name of the new modul
mmg_option - String of mmg-options

This value of 'mmg_option' will be extended by the value of the global 
variable 'mmc::mmg_opt'. 
++#

mmc::mmg:= proc( mname, mmg_option )
begin
	if( testargs() ) then
		if( args(0) < 1 or args(0) > 2 ) then
			error( "Wrong number of arguments" );
		end_if;
		
		if( domtype(mname) = DOM_IDENT ) then
			mname:= expr2text(mname);
		end_if;
		
		if( domtype(mname) <> DOM_STRING ) then
			error( "args(1): DOM_STRING expected" );
		end_if;
		
		if( args(0) = 2 ) then
			if( domtype(mmg_option) <> DOM_STRING ) then
				error( "args(2): DOM_STRING expected" );
			end_if;
		else
			mmg_option:= "";
		end_if;
	end_if;
		
	if  ( domtype(mmc::mmg_opt) = DOM_STRING ) then 
		mmg_option := mmg_option." ".mmc::mmg_opt;
		
	elif( domtype(mmc::mmg_opt) <> DOM_IDENT  ) then 
		print( Unquoted, 
		      "Warn.: 'mmc::mmg_opt': DOM_STRING expected".
		      ", ignored [mmg]"
		);
	end_if;

	print( Unquoted, "" );
	system( "mmg ".mname." ".mmg_option );
	null();
end_proc:

# end of file #
