# $Date: 1994/06/06 09:45:39 $ $Author: linus $ $Revision: 1.1 $ #

# andi, 07/03/94 #

#++
compile - main-function of MuPAD-Modul-Compiler

compile( mname, [, obj_set] [, mmg_options] )

mname        - Name of the new modul
obj_set      - Set of MuPAD (procedure-) names
mmg_options  - String of mmg-options

This is the main-function of the MuPAD-compiler. Every object given by
the set of names 'obj_set' will be compiled.  Two C-code files and one
special MuPAD-code file will be generated:

	<mname>.c	- modul-functions
	<mname>.h	- modul-definements
	<mname>.gen	- modul-generics
++#

mmc::compile:= proc( mname #, [, obj_set] [, mmg_opt_ions] # )
local	mmg_call_, mmg_opt_, n_, num_, PRETTY_PRINT;
begin
	PRETTY_PRINT := FALSE;

	print( Unquoted, mmc::version );
	
	#++ Get and check arguments +++++++++++++++++++++++++++++++++++++++++++#

	if( args(0) < 1 or args(0) > 3 ) then
		print( Unquoted, mmc::usage );
		error( "Wrong number of arguments" );
	end_if;
	
		#++ modul-name must be a string WITHOUT any `.' +++++++++++++++#
			
	if( domtype(args(1)) = DOM_IDENT ) then
		mmc::modul := expr2text( args(1) );
	else
		mmc::modul := args(1);
	end_if;
	
	if( domtype(mmc::modul) <> DOM_STRING ) then
		print( Unquoted, mmc::usage );
		error( "args(1): DOM_STRING or DOM_IDENT expected" );
	end_if;
	
	if( strmatch("\*.\*",mmc::modul) ) then
		print( Unquoted, mmc::usage );
		error( "args(1) must not contain any character '.'" );
	end_if;
		
		#++ Isolate and check the set of procedues to compile +++++++++#

	mmc::objects := [];
	mmc::nobjects:= -1;
	num_          := 2;

	if( args(0) >= num_ ) then
		if( domtype(args(num_)) = DOM_SET ) then
			mmc::objects := [op(args(num_))];
			mmc::nobjects:= nops(mmc::objects); 

			for n_ from 1 to mmc::nobjects do
				if( domtype(mmc::objects[n_])<>DOM_STRING ) then
				   error( "{...}: DOM_STRING expected" );
				end_if;
			end_for;
			num_ := 3;
		elif( args(0) > num_ ) then
			error( "args(2): DOM_SET expected" );
		end_if;
		
	end_if;
	
		#++ Isolate and check mmg-option-string +++++++++++++++++++++++#

	if( args(0) = num_ ) then
		if( domtype(args(num_)) <> DOM_STRING ) then
			print( Unquoted, mmc::usage );
			if( num_ = 3 ) then
			    error( "args(3): DOM_STRING expected" );
			else
			    error( "args(2): DOM_SET or DOM_STRING expected" );
			end_if;
		else
			mmg_opt_ := args(num_);
		end_if;
	else
		mmg_opt_ := "";
	end_if;

		#++ Too many arguments ? ++++++++++++++++++++++++++++++++++++++#
	
	if( args(0) > num_ ) then
		print( Unquoted, mmc::usage );
		error( "Wrong number of arguments" );
	end_if;
	
	#++ Pass-1: Modul-compiler: MuPAD-->C +++++++++++++++++++++++++++++++++#

	mmc::warnings:= 0;
	mmc::errors  := 0;

	if( mmc::nobjects >= 0 ) then
	
		mmc::m2c( FALSE );                   #++ First pass of 'm2c' ++#

		print( Unquoted, "" );
		print( Unquoted, "MMC: ".
		       mmc::errors  ." error(s), ".
		       mmc::warnings." warning(s), in ".
		       mmc::nobjects." object(s)"
		);
	
		if( mmc::errors > 0 ) then
			error( "Too many errors found" );
		end_if;
	end_if;

	       
	#++ Pass-2: Modul-generator: C-code --> modul +++++++++++++++++++++++++#

		#++ Check calling-conditions of 'mmg' +++++++++++++++++++++++++#
		
	if   ( domtype(mmc::mmg_call) = DOM_IDENT ) then      #++ undefined ++#
		mmg_call_:= TRUE;
	else
		mmg_call_:= mmc::mmg_call;
	end_if;
	
		#++ Call 'mmg' ++++++++++++++++++++++++++++++++++++++++++++++++#

	if( mmg_call_ = TRUE ) then mmc::mmg( mmc::modul, mmg_opt_ );
	end_if;
	
	null();
end_proc:

# end of file #
