################################################################################
### DATEI   : MuPAD-Demo - MDM/MMG/MMC                                       ###
### AUTOR   : Andreas Sorgatz                                                ###
### ERSTELLT: 09.05.94                                                       ###
### GEANDERT: 15.06.94                                                       ###
################################################################################

if( not loadmod() ) then 
	print( Unquoted, 
	"By now dynamic modules are not supported\n".
	"and this system !!!\n"
	):
end_if:

#++ Ermitteln, auf was fuer einem System MuPAD gerade laeuft ++++++++++++++++++#

SYS:= external("exec","slave")("sysinfo"):

#++ Definition der whichtiger Demo-Pfade ++++++++++++++++++++++++++++++++++++++#

MDM      := LIB_PATH.pathname( Up, "demo", "mmg" ):
MOD_PATH := external("stat","stdmod")()["mpath"]:
ROOT_PATH:= external("exec","slave")("echo $MuPAD_ROOT_PATH"):
SND_PATH := ROOT_PATH.pathname( "", "sun4", "sounds" ):

if( READ_PATH = hold(READ_PATH) ) then
	READ_PATH:= MDM, ".":
else
	READ_PATH:= MDM, ".", READ_PATH:
end_if:

#++ Ausgezeichnete Dateinamen +++++++++++++++++++++++++++++++++++++++++++++++++#

DEMO_1:= MDM."demo1.c":
CMATH := MDM."cmath.c":
SOUND := MDM."sound.c":

SOUNDM:= ( case SYS
	of "sun4"	do "sunsound"; break;
	of "solaris"	do "solsound"; break;
	otherwise	   "nosound" ; 
end_case ):

LIBM:= ( case SYS
	of "sun4"	do "fdm"; break;
	of "solaris"	do "m"  ; break;
	of "ibmrs6000"	do "m"  ; break;
	of "sgi5"	do "fdm"; break;
	of "i386"	do "m"  ; break;
	otherwise	   "m"  ;
end_case ):

#++ Testet, ob das aktuelle System in der Argumentenliste auftritt ++++++++++++#

check_system:= proc()
begin
   if( not contains({args()},SYS) ) then
      print( Unquoted, 
	 "###################################################\n".
         "# Sorry, this examples does work on your System ! #\n".
	 "###################################################\n".
	 "Your system: ".SYS
      );
      return( FALSE );
   end_if;
   TRUE;
end_proc:

#++ Test-Prozeduren fuer den Modul-Compiler 'mmc' +++++++++++++++++++++++++++++#

f1:= proc( a )
local  x;
begin
	x:= -a;
	return( float(2*x) );
end_proc:

smile:= proc( )
begin
	print( Unquoted, ";-)" );
end_proc:

#++ Initialisierung der Modulverwaltung +++++++++++++++++++++++++++++++++++++++#

unloadmod():

#++ End Of File +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#

TRUE:
