# $Date $ $Author $ $Revision $ #

# andi, 20.05.94 #

# maple.mu -- the 'maple' library for calling Maple slaves #

#++
User Functions:

open     - start the Maple slave
close    - close the Maple slave
put      - send a string to the Maple slave
get      - receive a string from the Maple slave
eval     - let Maple evaluate a given expression
++#

#++
This is a simple interface to start Maple slaves and install a text-based 
communication between them. By now, only Maple version V.2 is supported !
++#

proc()
    local path;
begin

maple:= domain():

maple::name:= "maple":
maple::info:= "Library 'maple': Communication with an external Maple slave":

maple::interface:= {	hold(open), hold(close), 
			hold(put), hold(get), hold(data),
			hold(eval)
}:

path:= pathname("maple"):

maple::open:=	loadproc(maple::open,  path, "open"):
maple::close:=	loadproc(maple::close, path, "close"):
maple::put:=	loadproc(maple::put,   path, "put"):
maple::get:=	loadproc(maple::get,   path, "get"):
maple::data:=	loadproc(maple::data,  path, "data"):
maple::eval:=	loadproc(maple::eval,  path, "eval"):

maple::new:= maple::eval:

maple::MAPLE     := "maple":            # name of the Maple program         #
maple::NO_TIMEOUT:= TRUE:               # wait until Maple sends an answer  #
maple::TIMEOUT   := 10:                 # only wait N seconds for an answer #
maple::sdesc     := []:                 # slave descriptor for maple        #
maple::last      := "":

end_proc():

# end of file #
