# #
# $Date: 1995/02/27 19:07:54 $  $Author: frankp $   $Revision: 1.5 $ #
# #
# frankp, 7/09/94 #

#++
        GaussianNumber(R)  -  Gaussian numbers over R

        R : ring

        A domain created by GaussianNumber defines the ring of gaussian
        numbers with coefficients of R. This ring is an integral domain
        iff R is it.
++#

GaussianNumber := DomainConstructor::new(
# #
# name #
    GaussianNumber,
# one argument: the coefficient ring R #
    [ R ],
# no local variables #
    [ ],
# initialisation #
    (if R::hasProp(Ring) <> TRUE then        
        error("expecting a Ring as argument")
     end_if),
# BaseDomain has to be super domain of any domain constructor #
    BaseDomain, 
# one categorie #
    [ (if R::hasProp(IntegralDomain) then
           IntegralDomain
       else
           Ring
       end_if)
    ],
# axioms: a gaussian number has of course a normal representation #
    [ (if R::hasProp(canonicalRep) then
           canonicalRep, normalRep
       else
           normalRep
       end_if)
    ],
# #
# methods #
    "new" = proc(a,b)
        local aR, bR;
    begin
        if testargs() then
            case args(0)
            of 1 do if domtype(a) = DOM_COMPLEX then
                        if not testtype( op(a,1),R )
                        or not testtype( op(a,2),R )
                        then
                            error("invalid argument")
                        end_if
                    elif not testtype( a,R ) then
                        error("invalid argument")
                    end_if;
                    break
            of 2 do if not testtype(a,R) or not testtype(b,R) then
                        error("invalid arguments")
                     end_if;
                    break
            otherwise
                error("wrong no of args")
            end_case
        end_if;

        case args(0)
        of 1 do if domtype(a) = DOM_COMPLEX then
                    aR := R::convert( op(a,1) );
                    bR := R::convert( op(a,2) );

                    return( new( this,aR,bR ) )
                end_if;
                aR := R::convert( a );
                if aR = FAIL then aR := a::convert_to( a,R ) end_if;
                
                return( new( this,aR,R::zero ) )
        of 2 do aR := R::convert( a ); bR := R::convert( b );
                if aR = FAIL then aR := a::convert_to( a,R ) end_if;
                if bR = FAIL then bR := b::convert_to( b,R ) end_if;

                new( this,aR,bR )
        end_case
    end_proc,

    "print" = proc(x)
    begin
	if iszero(extop(x,1)) then
	    expr2text( extop(x,2) )
	elif iszero(extop(x,2)) then
	    expr2text( extop(x,1) )
	else
	    "(".expr2text( extop(x,1)+I*extop(x,2) ).")"
	end_if
    end_proc,

    "one" = new( this,R::one,R::zero ),

    "zero" = new( this,R::zero,R::zero ),

    "iszero" = proc(x)
     begin
        bool( R::iszero( extop(x,1) ) and R::iszero( extop(x,2) ) )
    end_proc,
    
    "_plus" = proc(a,b)
	local t;
    begin
        if args(0) > 2 then
            return( this::_plus( a,this::_plus(args(i) $ hold(i)=2..args(0)) ) )
        end_if;

        if domtype(a) = this then
            if domtype(b) = this then
                t := (extop(a,1)+I*extop(a,2)) + (extop(b,1)+I*extop(b,2));
                return( new(this,Re(t),Im(t)) )
            elif testtype(b,R) then
                t := (extop(a,1)+I*extop(a,2)) + b;
                return( new(this,Re(t),Im(t)) )
            else
                FAIL
            end_if
        else
            return( this::_mult(b,a) )
        end_if
    end_proc,

    "_mult" = proc(a,b)        
	local t;
    begin
        if args(0) > 2 then
            return( this::_mult( a,this::_mult(args(i) $ hold(i)=2..args(0)) ) )
        end_if;
        
	if domtype(a) = this then
	    if domtype(b) = this then
		t := expand((extop(a,1)+I*extop(a,2)) * (extop(b,1)+I*extop(b,2)));
		return( new(this,Re(t),Im(t)) )
	    elif testtype(b,R) then
		t := expand( (extop(a,1)+I*extop(a,2)) * b );
		return( new(this,Re(t),Im(t)) )
	    else
		FAIL
	    end_if
	else
	    return( this::_mult(b,a) )
	end_if
    end_proc,

    "negate" = proc(x)
    begin
        new( this,R::negate(extop(x,1)),R::negate(extop(x,2)) )
    end_proc,

    "testtype" = proc(e,D)
        local d;
    begin
        d := domtype(e);
        if domtype(D) <> DOM_DOMAIN then D := domtype(D) end_if;

        if d = D then
            return( TRUE )
        elif d = this then
            if D = DOM_COMPLEX then
                if testtype( extop(e,1),Type::RealNum ) then
                    return( TRUE )
                end_if;
                 return( FALSE )
            elif R::iszero(extop(e,2)) then
                return( testtype( extop(e,1),D ) )
            end_if
        elif D = this then
            if d = DOM_COMPLEX then
                return( testtype( op(e,1),R ) and testtype( op(e,2),R ) )
            end_if;
            return( testtype( e,R ) )
        end_if;

        FAIL
    end_proc,

  "convert" = proc(e)
        local d, x1, x2;
    begin
        d := domtype(e);
        if d = this then return( e ) end_if;
        if d = DOM_COMPLEX then
            if testtype( op(e,1),R ) and testtype( op(e,2),R ) then
                d := op(e,1);
                 x1 := R::convert(d);
                if x1 = FAIL then x1 := d::convert_to(d,R) end_if;
                d := op(e,2);
                x2 := R::convert(d);
                if x2 = FAIL then x2 := d::convert_to(d,R) end_if;
        
                return( new( this,x1,x2 ) );
            end_if;
            return( FAIL )
        elif testtype( e,R ) then
            x1 := R::convert(e);
            if x1 = FAIL then x1 := d::convert_to(e,R) end_if;
            
            return( new( this,x1,R::zero ) )
        end_if;
        FAIL
    end_proc,

    "convert_to" = proc(e,D)
        local t;
    begin
        if domtype(e) = D then return(e) end_if;
        if domtype(D) <> DOM_DOMAIN then D := domtype(D) end_if;
        if domtype(e) = this then
            if D = DOM_COMPLEX then
                if testtype( extop(e,1),Type::RealNum ) then
                    return( extop(e,1)+I*extop(e,2) )
                end_if
            elif R::iszero(extop(e,2)) then
                if testtype( extop(e,1),D ) then
                    t := D::convert(extop(e,1));
                    if t = FAIL then t := R::convert_to(extop(e,1),D) end_if;

                    return( t )
                end_if
            end_if
        end_if;

        FAIL
    end_proc,

    "expr" = this::print,

    "norm" = 
        (if not testtype(R::one,Type::RealNum) then
            FAIL
        else
            proc(x)
            begin
                sqrt( R::_plus( R::_mult(extop(x,1),extop(x,1)),
                                R::_mult(extop(x,2),extop(x,2)) ) )
                end_proc
        end_if),

    "divex" = (
        if not R::hasProp( IntegralDomain ) then
            FAIL
        else
            proc(x,y)        
                 local x1, x2, y1, y2, d, d1, d2, n;
            begin
                x1 := extop(x,1); x2 := extop(x,2);
                y1 := extop(y,1); y2 := extop(y,2);
                d := R::_plus( R::_mult( y1,y1 ),R::_mult( y2,y2 ) );
                n := R::_plus( R::_mult( x1,y1 ),R::_mult( x2,y2 ) );
                d1 := R::divex( n,d );
                if d1 = FAIL then 
                    return( FAIL )
                end_if;

                n := R::_plus( R::negate(R::_mult( x1,y2 )),R::_mult( x2,y1 ) );
                d2 := R::divex( n,d );
                if d2 = FAIL then
                    return( FAIL )
                end_if;

                new( this,d1,d2 )
            end_proc
        end_if),

    "invert" = proc(x)
    begin
        this::divex( this::one,x )
    end_proc,    

    "diff" = this::zero
):

# end of file #
