# $Date: 1994/09/12 09:08:13 $  $Author: kg $  $Revision: 1.2 $ #

#++
ListOfIdents - returns type expression to test lists of identifiers

ListOfIdents([min [, max ]])

min - minimal number of elements (non-negative integer)
max - maximal number of elements (non-negative integer)

The type expression created returns TRUE if an expression is a list
of identifiers which has at least 'min' and at most 'max'
elements. If 'max' is missing the maximal number of list elements
dosn't matter. If 'min' and 'max' are missing the length of the list
dosn't matter.
++#

Type::ListOfIdents:= proc()
begin
    if testargs() then
	case args(0)
	of 2 do
	    if domtype(args(2)) <> DOM_INT or domtype(args(1)) <> DOM_INT then
		error("illegal length")
	    end_if;
	    if args(2) < args(1) then
		error("illegal maximal length")
	    end_if;
	    if args(1) < 0 then
		error("illegal minimal length")
	    end_if;
	    break;
	of 1 do
	    if domtype(args(1)) <> DOM_INT then
		error("illegal minimal length")
	    end_if;
	    if args(1) < 0 then
		error("illegal minimal length")
	    end_if;
	    break;
	of 0 do break;
	otherwise error("wrong no of args");
	end_case;
    end_if;

    new(Type,
	hold(ListOfIdents),
	(if args(0) = 0 then
	    proc(t,x)
		local e, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_LIST then
		    if nops(x) = 0 then
			TRUE
		    else
			bool( {op(map(x, domtype))} = {DOM_IDENT} );
		    end_if
		else
		    FALSE
		end_if;
	    end_proc
	else
	    proc(t,x)
		local e, r;
	    begin
		if args(0) <> 2 then return(FALSE) end_if;
		if domtype(x) = DOM_LIST then
		    case nops(t)
		    of 2 do
			if nops(x) > t[2] then return(FALSE) end_if;
		    of 1 do
			if nops(x) < t[1] then return(FALSE) end_if;
		    end_case;
		    if nops(x) = 0 then
			TRUE
		    else
			bool( {op(map(x, domtype))} = {DOM_IDENT} );
		    end_if
		else
		    FALSE
		end_if;
	    end_proc
	end_if),
	[ args() ], FALSE)
end_proc:

# remember case with no args #
Type::ListOfIdents():= Type::ListOfIdents():

# end of file #
