testdecompose := proc(p,x,n)
local q,r;
begin
   q:=[decompose(p,x)];
   if nops(q)<>n then error("wrong number of polynomials") end_if;
   r:=q[1];
   q[1]:=NIL;
   while q<>[] do
      r:=expand(subs(r,x=q[1]));
      q[1]:=NIL
   end_while;
   if r<>p then error("wrong decomposition") end_if
end_proc:

testdecompose(x^12+13*x^8+17*x^4+9,x,3);

testdecompose(x^6+6*x^4+x^3+9*x^2+3*x-5,x,2);

testdecompose(x^6-9*x^5+27*x^4-27*x^3-2*x^2*y+6*x*y+1,x,2);

testdecompose(x^4-3*x^3-x+5,x,1);

if [decompose(poly(x^4-3*x^3-x+5,[x],IntMod(5)))]<>[poly(x^2-x,[x],IntMod(5)),
	poly(x^2+x,[x],IntMod(5))] then error("decompose") end_if;

# example on page 151 of [GoSaZi95] #
p:=4*x^8+48*x^7+256*x^6+792*x^5+1590*x^4+2196*x^3+2104*x^2+1290*x+459:
testdecompose(p,x,3);

quit
